#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
import sys
import logging
import traceback
import pypinyin
from pypinyin import lazy_pinyin
from gm_types.gaia import SERVICE_ITEM_PRICE_TYPE, DOCTOR_TYPE
import uuid


def uuid4():
    """

    :return:
    """
    return uuid.uuid4().hex


def get_tips_suggest_list(instance_cn_name):
    try:
        # ch_full_weight = 6.0 * 1000
        # py_full_weight = 3.0 * 1000
        full_weight = 3.0 * 1000
        py_acronym_full_weight = 3.0 * 1000

        py_acronym_prefix_weight = 2
        ch_prefix_weight = 1.5
        py_prefix_weight = 1.0

        # 命中开始部分加权
        begin_prefix_weight = 1.2 * 1000

        ch_full_word = instance_cn_name.strip()
        py_full_word = ''.join(lazy_pinyin(ch_full_word))
        py_acronym_full_word = ''.join(lazy_pinyin(ch_full_word, style=pypinyin.FIRST_LETTER))

        suggest_dict = dict()
        cur_index = 0
        # 中文
        for i in range(len(ch_full_word)):
            ch_name_term = ch_full_word[i:].strip()
            if ch_name_term and ch_full_word[i] != "（" and ch_full_word[i] != "）":
                prefix_weight = ch_prefix_weight if len(ch_name_term) != len(ch_full_word) else full_weight
                suggest_type = 0 if len(ch_name_term) != len(ch_full_word) else 1
                term_begin_prefix_weight = begin_prefix_weight if i == 0 else 1.0
                suggest_item = {
                    "input": [ch_name_term],
                    "word_weight": 100 + (1.0 * len(ch_name_term) / len(
                        (ch_full_word))) * prefix_weight * term_begin_prefix_weight,
                    "suggest_type": suggest_type
                }
                if ch_name_term[0] not in suggest_dict:
                    cur_index += 1
                    suggest_item["cur_index"] = cur_index
                    suggest_dict[ch_name_term[0]] = suggest_item
                else:
                    suggest_dict[ch_name_term[0]]["input"].append(ch_name_term)
                    if suggest_item["word_weight"] > suggest_dict[ch_name_term[0]]["word_weight"]:
                        suggest_dict[ch_name_term[0]]["word_weight"] = 100 + int(suggest_item["word_weight"])
                        suggest_dict[ch_name_term[0]]["suggest_type"] = suggest_item["suggest_type"]
                        # 拼音
        if py_full_word != ch_full_word:
            for i in range(len(py_full_word)):
                py_name_term = py_full_word[i:].strip()
                if py_name_term and py_full_word[i] != "（" and py_full_word[i] != "）":
                    prefix_weight = py_prefix_weight if len(py_name_term) != len(py_full_word) else full_weight
                    suggest_type = 2 if len(py_name_term) != len(py_full_word) else 3
                    term_begin_prefix_weight = begin_prefix_weight if i == 0 else 1.0
                    suggest_item = {
                        "input": [py_name_term],
                        "word_weight": 100 + (1.0 * len(py_name_term) / len(
                            py_full_word)) * prefix_weight * term_begin_prefix_weight,
                        "suggest_type": suggest_type
                    }

                    if py_name_term[0] not in suggest_dict:
                        cur_index += 1
                        suggest_item["cur_index"] = cur_index
                        suggest_dict[py_name_term[0]] = suggest_item
                    else:
                        suggest_dict[py_name_term[0]]["input"].append(py_name_term)
                        if suggest_item["word_weight"] > suggest_dict[py_name_term[0]]["word_weight"]:
                            suggest_dict[py_name_term[0]]["word_weight"] = 100 + int(suggest_item["word_weight"])
                            suggest_dict[py_name_term[0]]["suggest_type"] = suggest_item["suggest_type"]

                            # 简写
        if py_acronym_full_word != py_full_word:
            for i in range(len(py_acronym_full_word)):
                py_acronym_term = py_acronym_full_word[i:].strip()
                if py_acronym_term and py_acronym_full_word[i] != "（" and py_acronym_full_word[i] != "）":
                    prefix_weight = py_acronym_prefix_weight if len(py_acronym_term) != len(
                        py_acronym_full_word) else py_acronym_full_weight
                    suggest_type = 4 if len(py_acronym_term) != len(py_acronym_full_word) else 5
                    term_begin_prefix_weight = begin_prefix_weight if i == 0 else 1.0
                    suggest_item = {
                        "input": [py_acronym_term],
                        "word_weight": 100 + (1.0 * len(py_acronym_term) / len(
                            py_acronym_full_word)) * prefix_weight * term_begin_prefix_weight,
                        "suggest_type": suggest_type
                    }
                    if py_acronym_term[0] not in suggest_dict:
                        cur_index += 1
                        suggest_item["cur_index"] = cur_index
                        suggest_dict[py_acronym_term[0]] = suggest_item
                    else:
                        suggest_dict[py_acronym_term[0]]["input"].append(py_acronym_term)
                        if suggest_item["word_weight"] > suggest_dict[py_acronym_term[0]]["word_weight"]:
                            suggest_dict[py_acronym_term[0]]["word_weight"] = 100 + int(suggest_item["word_weight"])
                            suggest_dict[py_acronym_term[0]]["suggest_type"] = suggest_item["suggest_type"]

        return suggest_dict.values()
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return list()


def get_tips_suggest_list_v1(instance_cn_name):
    try:
        # ch_full_weight = 6.0 * 1000
        # py_full_weight = 3.0 * 1000
        full_weight = 1
        py_acronym_full_weight = 1

        py_acronym_prefix_weight = 1
        ch_prefix_weight = 1
        py_prefix_weight = 1.0

        # 命中开始部分加权
        begin_prefix_weight = 1

        ch_full_word = instance_cn_name.strip()
        py_full_word = ''.join(lazy_pinyin(ch_full_word))
        py_acronym_full_word = ''.join(lazy_pinyin(ch_full_word, style=pypinyin.FIRST_LETTER))

        suggest_dict = dict()
        cur_index = 0
        # 中文
        for i in range(len(ch_full_word)):
            ch_name_term = ch_full_word[i:].strip()
            if ch_name_term and ch_full_word[i] != "（" and ch_full_word[i] != "）":
                prefix_weight = ch_prefix_weight if len(ch_name_term) != len(ch_full_word) else full_weight
                suggest_type = 0 if len(ch_name_term) != len(ch_full_word) else 1
                term_begin_prefix_weight = begin_prefix_weight if i == 0 else 1.0
                suggest_item = {
                    "input": [ch_name_term],
                    "word_weight": (1.0 * len(ch_name_term) / len(
                        (ch_full_word))) * prefix_weight * term_begin_prefix_weight,
                    "suggest_type": suggest_type
                }
                if ch_name_term[0] not in suggest_dict:
                    cur_index += 1
                    suggest_item["cur_index"] = cur_index
                    suggest_dict[ch_name_term[0]] = suggest_item
                else:
                    suggest_dict[ch_name_term[0]]["input"].append(ch_name_term)
                    if suggest_item["word_weight"] > suggest_dict[ch_name_term[0]]["word_weight"]:
                        suggest_dict[ch_name_term[0]]["word_weight"] = suggest_item["word_weight"]
                        suggest_dict[ch_name_term[0]]["suggest_type"] = suggest_item["suggest_type"]
                        # 拼音
        if py_full_word != ch_full_word:
            for i in range(len(py_full_word)):
                py_name_term = py_full_word[i:].strip()
                if py_name_term and py_full_word[i] != "（" and py_full_word[i] != "）":
                    prefix_weight = py_prefix_weight if len(py_name_term) != len(py_full_word) else full_weight
                    suggest_type = 2 if len(py_name_term) != len(py_full_word) else 3
                    term_begin_prefix_weight = begin_prefix_weight if i == 0 else 1.0
                    suggest_item = {
                        "input": [py_name_term],
                        "word_weight": (1.0 * len(py_name_term) / len(
                            py_full_word)) * prefix_weight * term_begin_prefix_weight,
                        "suggest_type": suggest_type
                    }

                    if py_name_term[0] not in suggest_dict:
                        cur_index += 1
                        suggest_item["cur_index"] = cur_index
                        suggest_dict[py_name_term[0]] = suggest_item
                    else:
                        suggest_dict[py_name_term[0]]["input"].append(py_name_term)
                        if suggest_item["word_weight"] > suggest_dict[py_name_term[0]]["word_weight"]:
                            suggest_dict[py_name_term[0]]["word_weight"] = suggest_item["word_weight"]
                            suggest_dict[py_name_term[0]]["suggest_type"] = suggest_item["suggest_type"]

                            # 简写
        if py_acronym_full_word != py_full_word:
            for i in range(len(py_acronym_full_word)):
                py_acronym_term = py_acronym_full_word[i:].strip()
                if py_acronym_term and py_acronym_full_word[i] != "（" and py_acronym_full_word[i] != "）":
                    prefix_weight = py_acronym_prefix_weight if len(py_acronym_term) != len(
                        py_acronym_full_word) else py_acronym_full_weight
                    suggest_type = 4 if len(py_acronym_term) != len(py_acronym_full_word) else 5
                    term_begin_prefix_weight = begin_prefix_weight if i == 0 else 1.0
                    suggest_item = {
                        "input": [py_acronym_term],
                        "word_weight": (1.0 * len(py_acronym_term) / len(
                            py_acronym_full_word)) * prefix_weight * term_begin_prefix_weight,
                        "suggest_type": suggest_type
                    }
                    if py_acronym_term[0] not in suggest_dict:
                        cur_index += 1
                        suggest_item["cur_index"] = cur_index
                        suggest_dict[py_acronym_term[0]] = suggest_item
                    else:
                        suggest_dict[py_acronym_term[0]]["input"].append(py_acronym_term)
                        if suggest_item["word_weight"] > suggest_dict[py_acronym_term[0]]["word_weight"]:
                            suggest_dict[py_acronym_term[0]]["word_weight"] = suggest_item["word_weight"]
                            suggest_dict[py_acronym_term[0]]["suggest_type"] = suggest_item["suggest_type"]

        return suggest_dict.values()
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return list()
