#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
import sys
import logging
import traceback
from libs.tools import tzlc,getMd5Digest
from libs.es import ESPerform
from libs.cache import redis_client
import json
from django.conf import settings
from trans2es.models import wordresemble

class WordResemble(object):

    @classmethod
    def get_word_resemble_list(cls,keyword):
        try:
            query_sql_item = wordresemble.WordRel.objects.filter(keyword=keyword)

            temp_list = list()
            for sql_obj in query_sql_item:
                temp_list.extend(list(sql_obj.all_resembles.all().values_list('word',flat=True)))


            resemble_list = list()
            for item in temp_list:
                resemble_list.extend(item.split("、"))

            return resemble_list
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return list()