# coding=utf8
from __future__ import unicode_literals, absolute_import, print_function

import operator

from django.db import models
from django.db.models import Q
from django.db import transaction
from gm_types.gaia import TAG_ALERT_TYPE


manager = lambda: models.Manager().db_manager(using='bran')


class TagConversion(models.Model):
    class Meta:
        verbose_name = '综合、美购、日记tab'
        db_table = 'trade_tag_conversion'
        get_latest_by = 'update_date'
        unique_together = ('update_date', 'province_id', 'business_id')

    objects = manager()

    update_date = models.DateField()
    province_id = models.CharField(max_length=40)
    query = models.CharField(max_length=120, verbose_name='搜索时的关键词')
    business_id = models.IntegerField(verbose_name='关键词精确匹配的tagID')
    business_type = models.CharField(max_length=5, verbose_name='tag分级')
    search_rate = models.FloatField(verbose_name='搜索次数占比')
    conversion_rate = models.FloatField(verbose_name='tag转化率')


class DoctorConversion(models.Model):
    class Meta:
        verbose_name = '医生tab'
        db_table = 'trade_doctor_conversion'
        get_latest_by = 'update_date'
        unique_together = ('update_date', 'province_id', 'business_id')

    objects = manager()

    update_date = models.DateField()
    province_id = models.CharField(max_length=40)
    query = models.CharField(max_length=128)
    business_id = models.CharField(max_length=100)
    business_type = models.CharField(max_length=1)
    search_rate = models.FloatField()
    conversion_rate = models.FloatField()


class HospitalConversion(models.Model):
    class Meta:
        verbose_name = '医院tab'
        db_table = 'trade_hospital_conversion'
        get_latest_by = 'update_date'
        unique_together = ('update_date', 'province_id', 'business_id')

    objects = manager()

    update_date = models.DateField()
    province_id = models.CharField(max_length=40)
    query = models.CharField(max_length=128)
    business_id = models.CharField(max_length=100)
    business_type = models.CharField(max_length=1)
    search_rate = models.FloatField()
    conversion_rate = models.FloatField()
