#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
import sys
import logging
import traceback
from libs.tools import tzlc
from libs.es import ESPerform
from libs.cache import redis_client
import json

from trans2es.commons.commons import get_tips_suggest_list

class BrandWikiTransfer(object):

    test_es_info_list = [
        {'host': '10.30.57.94', 'port': 9200}
    ]

    @classmethod
    def get_brandwiki_suggest_data_list(cls, instance):
        try:
            ret_list = list()

            item_dict = dict()
            item_dict["id"] = instance.id
            item_dict["ori_name"] = instance.name
            item_dict["is_online"] = instance.is_online

            item_dict["order_weight"] = 0.0
            item_dict["results_num"] = 0
            item_dict["type_flag"] = "unknown"
            item_dict["offline_score"] = 0.0
            item_dict["tips_name_type"] = 3

            ret_list.append(item_dict)

            suggest_list = get_tips_suggest_list(instance.name)

            return (item_dict,suggest_list)
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return ([],[])