#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, absolute_import, print_function
from gm_rpcd.all import bind
import logging
import traceback
import json
from libs.es import ESPerform
from libs.cache import redis_client
from libs.tools import json_http_response
from search.utils.auto_tips import get_suggest_tips



@bind("search_tips/search/auto_complete")
def auto_complete(q):
    try:
        """auto complate words/tags/doctors etc.

        URL:
            ~/api/auto_complete?scope=[kw]&q=双

        Return:
            {'error': 0|1, 'data': [word, word, word],}
        """

        # q = request.GET.get('q', '').strip()
        # if not q:
        #     return json_http_response({'error': 0, 'data': []})

        data = get_suggest_tips(q)

        result = {
            'error': 0,
            'data': data,
        }
        return {"data":data}
        #return json_http_response(result)
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return {"data":[]}
        #return json_http_response({'error': 1, 'data': []})

