# -*- coding: UTF-8 -*-
import logging
import traceback
import json
import pymysql
import threading
import random
import datetime
from celery import shared_task
from django.conf import settings
from django.core import serializers
from associate.type_info import get_type_info_map as get_type_info_associate
from trans2es.type_info import get_type_info_map
# from rpc.all import get_rpc_remote_invoker
from libs.es import ESPerform
from libs.cache import redis_client


@shared_task
def write_to_es(es_type, pk_list, use_batch_query_set=False):
    logging.info("get -----------------")
    logging.info("consume es_type:%s" % str(es_type))
    try:

        if es_type == "suggest_v1" or es_type == "suggest":
            pk_list = list(frozenset(pk_list))
            type_info_map = get_type_info_map()
            type_info = type_info_map[es_type]

            type_info.insert_table_by_pk_list(
                sub_index_name=type_info.name,
                pk_list=pk_list,
                use_batch_query_set=use_batch_query_set,
                es=ESPerform.get_cli()
            )

        else:
            if es_type == "suggest_v1" or es_type == "suggest":
                pk_list = list(frozenset(pk_list))
                type_info_map = get_type_info_associate()
                type_info = type_info_map[es_type]

                type_info.insert_table_by_pk_list(
                    sub_index_name=type_info.name,
                    pk_list=pk_list,
                    use_batch_query_set=use_batch_query_set,
                    es=ESPerform.get_cli()
                )

    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
