#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, absolute_import, print_function
from gm_rpcd.all import bind
import logging
import traceback
import json
from libs.es import ESPerform
from libs.cache import redis_client



def get_suggest_tips(query,offset=0,size=100):
    try:
        q = {
            "suggest":{
                    "tips-suggest": {
                            "prefix": query,
                            "completion": {
                                "field": "suggest"
                            }
                    }
            },
            "sort": [
                {"offline_score": {"order": "desc"}}
            ],
            "_source": {
                "include": ["id", "ori_name", "offline_score", "is_online"]
            }
        }

        ret_list = list()
        result_dict = ESPerform.get_search_results(ESPerform.get_cli(),sub_index_name="tag",query_body=q,offset=offset,size=size,is_suggest_request=True)
        for tips_item in result_dict["suggest"]["tips-suggest"]:
            for hit_item in tips_item["options"]:
                ret_list.append(hit_item["_source"])

        return ret_list
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return list()
