# coding=utf8
from __future__ import unicode_literals, absolute_import, print_function

import operator

from django.db import models
from django.db.models import Q
from django.db import transaction
import logging
import traceback
from gm_types.gaia import TAG_ALERT_TYPE

from django.utils import timezone
from gm_upload import IMG_TYPE, ImgUrlField
from gm_types.gaia import WORDREL_CATEGORY


class WordRel(models.Model):
    class Meta:
        app_label = 'api'
        db_table = 'api_wordrel'

    keyword = models.CharField(u'关键字', max_length=50)
    category = models.CharField(u'分类', max_length=5, choices=WORDREL_CATEGORY)
    created_time = models.DateTimeField(verbose_name=u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(verbose_name=u'最后更新时间', auto_now=True)


class WordRelResemble(models.Model):
    """近义词数据表
    """

    class Meta:
        app_label = 'api'
        db_table = 'api_wordrelresemble'

    wordrel = models.ForeignKey(WordRel, related_name='all_resembles')
    word = models.CharField(u'近义词', max_length=50, db_index=True)


class WordRelSynonym(models.Model):
    """
    同义词数据表
    """

    class Meta:
        app_label = "api"
        db_table = "api_wordrelsynonym"

    wordrel = models.ForeignKey(WordRel, related_name='all_resembles')
    word = models.CharField(u'同义词', max_length=50, db_index=True)
