#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
import sys
import logging
import traceback
from libs.tools import tzlc,getMd5Digest
from libs.es import ESPerform
from libs.cache import redis_client
import json

from trans2es.commons.commons import get_tips_suggest_list
from trans2es.commons.words_utils import QueryWordAttr,get_tips_word_type

class HospitalTransfer(object):

    @classmethod
    def get_hospital_suggest_data_list(cls, instance):
        try:
            ret_list = list()

            item_dict = dict()
            item_dict["id"] = getMd5Digest(str(instance.name))
            item_dict["ori_name"] = instance.name
            item_dict["is_online"] = instance.is_online

            item_dict["order_weight"] = QueryWordAttr.get_hospital_query_word_weight(instance.name)
            item_dict["results_num"] = QueryWordAttr.get_query_results_num(instance.name)
            item_dict["type_flag"] = get_tips_word_type(instance.name)
            item_dict["offline_score"] = 0.0
            item_dict["tips_name_type"] = 1

            ret_list.append(item_dict)

            suggest_list = get_tips_suggest_list(instance.name)

            return (item_dict,suggest_list)
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return ([],[])

    @classmethod
    def get_hospital_lat_lng_info_to_redis(cls, instance):
        try:
            redis_key_prefix = "search_tips:hospital_latlng_info"
            name = instance.name
            lng = instance.baidu_loc_lng
            lat = instance.baidu_loc_lat

            pos_list = [lng,lat]
            redis_client.hset(redis_key_prefix,name,pos_list)
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
