from __future__ import unicode_literals, absolute_import, print_function

# !/usr/bin/env python
# -*- coding: utf-8 -*-
import logging
import traceback
import base64
from django.db import models
# from gm_types.gaia import (
#     AGILE_TAG_TYPE,
#     AGILE_TAG_CREATE_TYPE,
#     AGILE_TAG_STYLE,
#     AGILE_TAG_RECOMMEND_TYPE,
# )


class BaseModel(models.Model):
    class Meta:
        abstract = True

    is_online = models.BooleanField(verbose_name=u"是否有效", default=True)
    create_time = models.DateTimeField(verbose_name=u'创建时间', auto_now_add=True)
    update_time = models.DateTimeField(verbose_name=u'更新时间', auto_now=True)


class AgileTag(BaseModel):
    class Meta:
        verbose_name = u'新标签'
        db_table = 'api_agile_tag'
        app_label = 'api'

    name = models.CharField(verbose_name=u'新标签名字', max_length=128, null=False, unique=True, default='')
    description = models.TextField(verbose_name=u'描述', default='')
    create_tag_type = models.CharField(verbose_name=u"标签创建类型", max_length=3, choices=1)
    style = models.CharField(verbose_name=u"标签样式", max_length=3, choices=1)
    topic_recommend_sort = models.IntegerField(verbose_name=u'帖子推荐排序', default=9999)


class AgileTagType(BaseModel):
    class Meta:
        verbose_name = u'新标签类型(可多选)'
        db_table = 'api_agile_tag_type'
        app_label = 'api'

    agile_tag_id = models.IntegerField(verbose_name=u'新标签', db_index=True)
    agile_tag_type = models.CharField(verbose_name=u"标签类型", max_length=3, choices=1)

    @property
    def get_by_id_name(self):
        try:
            results = AgileTag.objects.filter(id=self.agile_tag_id).values()

            return results[0]
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return {}



# class AgileTagRecommendType(BaseModel):
#     class Meta:
#         verbose_name = u'新标签推荐类型(可多选)'
#         db_table = 'api_agile_tag_recommend_type'
#         app_label = 'api'
#
#     agile_tag_id = models.IntegerField(verbose_name=u'新标签', db_index=True)
#     agile_tag_type = models.CharField(verbose_name=u"标签推荐类型", max_length=3, choices=AGILE_TAG_RECOMMEND_TYPE)

#
# class AgileTagMapping(BaseModel):
#     class Meta:
#         verbose_name = u'新标签与老标签映射关系(可多选)'
#         db_table = 'api_agile_tag_mapping'
#         app_label = 'api'
#
#     agile_tag_id = models.IntegerField(verbose_name=u'新标签', db_index=True)
#     old_tag_id = models.IntegerField(verbose_name=u'老标签', db_index=True)

#
# class AgileTagRelationPolymer(BaseModel):
#     class Meta:
#         verbose_name = u'新标签关联的内容聚合页(可多选)'
#         db_table = 'api_agile_tag_relation_polymer'
#         app_label = 'api'
#
#     agile_tag_id = models.IntegerField(verbose_name=u'新标签', db_index=True)
#     polymer_id = models.IntegerField(verbose_name=u'聚合页id', db_index=True)
