# -*- coding: utf-8 -*-
from __future__ import unicode_literals, absolute_import, print_function
import datetime
from django.db import models

from gm_types.wiki import TREATMENT_TYPE, ANESTHESIA_TYPE, ACHE_LEVEL_NEW

import traceback
import logging


class ItemWiki(models.Model):
    class Meta:
        verbose_name = u'项目新百科'
        db_table = 'wiki_item'

    id = models.IntegerField(verbose_name=u'百科ID', primary_key=True)
    name = models.CharField(u'项目名称', max_length=48)
    description = models.TextField(u'介绍')
    use_result = models.CharField(u'使用功效', max_length=128)
    is_online = models.BooleanField(u'是否上线', default=True)
    create_time = models.DateTimeField(verbose_name=u'创建时间', default=datetime.datetime.fromtimestamp(0))
