# -*- coding: UTF-8 -*-
import logging
import traceback
from celery import shared_task
from associate.type_info import get_type_info_map as get_type_info_associate
from trans2es.type_info import get_type_info_map
from libs.es import ESPerform


@shared_task
def write_to_es(es_type, pk_list, use_batch_query_set=False):
    logging.info("consume es_type:%s" % str(es_type))
    try:

        suggest_index_type = ["doctor_tips", "hospital_tips", "itemwiki_tips", "collectwiki_tips",
                              'brandwiki_tips', "productwiki_tips", 'tag_tips', 'wordrel_tips']
        if es_type in suggest_index_type:
            pk_list = list(frozenset(pk_list))
            type_info_map = get_type_info_map()
            type_info = type_info_map[es_type]

            type_info.insert_table_by_pk_list(
                sub_index_name=type_info.name,
                pk_list=pk_list,
                use_batch_query_set=use_batch_query_set,
                es=ESPerform.get_cli(),
                es_type=es_type
            )
        else:
            pk_list = list(frozenset(pk_list))
            type_info_map = get_type_info_associate()
            type_info = type_info_map[es_type]

            type_info.insert_table_by_pk_list(
                sub_index_name=type_info.name,
                pk_list=pk_list,
                use_batch_query_set=use_batch_query_set,
                es=ESPerform.get_cli()
            )

    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
