#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
import sys
import logging
import traceback
from libs.tools import tzlc

import pypinyin
from pypinyin import lazy_pinyin

class DoctorTransfer(object):

    ch_full_weight = 6.0
    py_full_weight = 3.0
    py_acronym_full_weight = 3.0

    py_acronym_prefix_weight = 2
    ch_prefix_weight = 1.5
    py_prefix_weight = 1.0

    # 命中开始部分加权
    begin_prefix_weight = 1.2

    @classmethod
    def get_doctor_data_name_mapping_results_to_redis(cls, instance):
        try:
            doctor_name = instance.name
            if doctor_name.strip():
                multi_fields = {
                    'hospital.city_province_name': 1,
                    'hospital.name': 1,
                    'name': 1,
                    'hospital.city_name':1,
                    'hospital.officer_name':1,
                    'service_closure_tags':1
                }
                query_fields = ['^'.join((k, str(v))) for (k, v) in multi_fields.items()]
                multi_match = {
                    'query': doctor_name,
                    'type': 'cross_fields',
                    'operator': 'and',
                    'fields': query_fields,
                }

        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())



    @classmethod
    def get_doctor_suggest_data_list(cls,instance):
        try:
            ret_list = list()

            item_dict = dict()
            item_dict["id"] = instance.id
            item_dict["ori_name"] = instance.name
            item_dict["is_online"] = instance.is_online

            item_dict["order_weight"] = 0.0
            item_dict["results_num"] = 0
            item_dict["type_flag"] = "unknown"
            item_dict["offline_score"] = 0.0
            item_dict["tips_name_type"] = 2

            ret_list.append(item_dict)
            suggest_list = list()

            ch_full_word = instance.name
            py_full_word = ''.join(lazy_pinyin(ch_full_word))
            py_acronym_full_word = ''.join(lazy_pinyin(ch_full_word,style=pypinyin.FIRST_LETTER))

            cur_index = 0
            #中文
            for i in range(len(ch_full_word)):
                for j in range(i,len(ch_full_word)+1):
                    ch_name_term = ch_full_word[i:j].strip()
                    if ch_name_term:
                        prefix_weight = cls.ch_prefix_weight if len(ch_name_term)!=len(ch_full_word) else cls.ch_full_weight
                        suggest_type = 0 if len(ch_name_term)!=len(ch_full_word) else 1
                        begin_prefix_weight = cls.begin_prefix_weight if i==0 else 1.0
                        suggest_item = {
                            "input":[ch_name_term],
                            "word_weight":(1.0*len(ch_name_term)/len((ch_full_word))) * prefix_weight * begin_prefix_weight,
                            "suggest_type": suggest_type,
                            "cur_index": cur_index
                        }
                        cur_index += 1
                        suggest_list.append(suggest_item)

            #拼音
            for i in range(len(py_full_word)):
                for j in range(i,len(py_full_word)+1):
                    py_name_term = py_full_word[i:j].strip()
                    if py_name_term:
                        prefix_weight = cls.py_prefix_weight if len(py_name_term)!=len(py_full_word) else cls.py_full_weight
                        suggest_type = 2 if len(py_name_term)!=len(py_full_word) else 3
                        begin_prefix_weight = cls.begin_prefix_weight if i==0 else 1.0
                        suggest_item = {
                            "input":[py_name_term],
                            "word_weight":(1.0*len(py_name_term)/len(py_full_word)) * prefix_weight * begin_prefix_weight,
                            "suggest_type": suggest_type,
                            "cur_index": cur_index
                        }
                        cur_index += 1
                        suggest_list.append(suggest_item)

            #简写
            for i in range(len(py_acronym_full_word)):
                for j in range(i,len(py_acronym_full_word)+1):
                    py_acronym_term = py_acronym_full_word[i:j].strip()
                    if py_acronym_term:
                        prefix_weight = cls.py_acronym_prefix_weight if len(py_acronym_term)!=len(py_acronym_full_word) else cls.py_acronym_full_weight
                        suggest_type = 4 if len(py_acronym_term)!=len(py_acronym_full_word) else 5
                        begin_prefix_weight = cls.begin_prefix_weight if i==0 else 1.0
                        suggest_item = {
                            "input":[py_acronym_term],
                            "word_weight":(1.0*len(py_acronym_term)/len(py_acronym_full_word)) * prefix_weight * begin_prefix_weight,
                            "suggest_type": suggest_type,
                            "cur_index": cur_index
                        }
                        cur_index += 1
                        suggest_list.append(suggest_item)

            return (item_dict,suggest_list)
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return ([],[])
