# -*- coding: utf-8 -*-
from __future__ import unicode_literals, absolute_import, print_function

from django.db import models
import logging
import traceback
import datetime


class BrandWiki(models.Model):
    class Meta:
        verbose_name = u'品牌'
        db_table = 'wiki_brand'

    id = models.IntegerField(verbose_name=u'品牌ID', primary_key=True)
    name = models.CharField(u'项目介绍', max_length=48)
    description = models.TextField(u'品牌简介')
    is_online = models.BooleanField(u'是否上线', default=True)
    create_time = models.DateTimeField(verbose_name=u'创建时间', default=datetime.datetime.fromtimestamp(0))
