#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, absolute_import, print_function
from gm_rpcd.all import bind
import logging
import traceback
import json
from libs.es import ESPerform
from libs.cache import redis_client
from libs.tools import g_hospital_pos_dict
from libs.tools import point_distance


def get_suggest_tips(query,lat,lng,offset=0,size=100):
    try:
        q = {
            "suggest":{
                    "tips-suggest": {
                            "prefix": query,
                            "completion": {
                                "field": "suggest"
                            }
                    }
            },
            "sort": [
                {"offline_score": {"order": "desc"}}
            ],
            "_source": {
                "include": ["id", "ori_name", "offline_score", "is_online","type_flag","results_num"]
            }
        }

        ret_list = list()
        result_dict = ESPerform.get_search_results(ESPerform.get_cli(),sub_index_name="suggest",query_body=q,offset=offset,size=size,is_suggest_request=True)
        for tips_item in result_dict["suggest"]["tips-suggest"]:
            for hit_item in tips_item["options"]:

                highlight_marks = u'<ems>%s</ems>' % query
                hit_item["_source"]["highlight_name"] = hit_item["_source"]["ori_name"].replace(query,highlight_marks)

                if hit_item["_source"]["type_flag"] == "hospital":
                    if hit_item["_source"]["ori_name"] in g_hospital_pos_dict:
                        distance = point_distance(lng,lat,g_hospital_pos_dict[hit_item["_source"]["ori_name"]][0],g_hospital_pos_dict[hit_item["_source"]["ori_name"]][1])
                        if distance < 1000*10000:
                            if distance < 1000:
                                if distance < 100:
                                    hit_item["_source"]["describe"] = "<100" + "米"
                                else:
                                    hit_item["_source"]["describe"] = "约" + str(distance) + "米"
                            else:
                                hit_item["_source"]["describe"] = "约" + str(1.0*distance/1000) + "km"
                        else:
                            hit_item["_source"]["describe"] = ">1000km"
                    else:
                        hit_item["_source"]["describe"] = ""
                else:
                    hit_item["_source"]["describe"] = "约"+str(hit_item["_source"]["results_num"])+"个结果" if hit_item["_source"]["results_num"] else ""
                ret_list.append(hit_item["_source"])

        return ret_list
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return list()
