# -*- coding: utf-8 -*-
from __future__ import unicode_literals, absolute_import, print_function

from django.db import models
from gm_types.wiki import PRODUCT_PARAMS, ANESTHESIA_TYPE, TREATMENT_TYPE
import logging, traceback
import datetime


class ProductWiki(models.Model):
    class Meta:
        verbose_name = u'物品百科'
        db_table = 'wiki_product'

    id = models.IntegerField(u"物品百科id", primary_key=True)
    name = models.CharField(u'物品名称', max_length=50)
    product_type = models.CharField(u'物品类型', max_length=4)
    brand_id = models.IntegerField(u"商品id", null=True)
    description = models.TextField(u'项目描述', blank=True)
    special = models.TextField(u'特色')
    effect = models.CharField(u'功效', max_length=128)
    treatment_method = models.CharField(u'治疗方式', max_length=8, choices=TREATMENT_TYPE)
    is_online = models.BooleanField(u'是否上线', default=True)
    create_time = models.DateTimeField(verbose_name=u'创建时间', default=datetime.datetime.fromtimestamp(0))
