import time

from utils.images import (BASE_DIR, MODELS_DIR, face_to_vec, file_to_ndarray, url_to_ndarray)


def main():
    img_url = "https://pic.igengmei.com/2020/07/04/1802/1fd23e101178-w"
    img = url_to_ndarray(img_url)
    print(img)

    faces = face_to_vec(img)

    print(faces)
    print("============")

    for face in faces:
        print(face["feature"] + "\n")


if __name__ == "__main__":
    begin_time = time.time()

    print("base_dir: " + BASE_DIR)
    print("models_dir: " + MODELS_DIR)

    main()

    print("total cost: " + str(time.time() - begin_time))
