from libs.rpc import get_rpc_invoker
import traceback
from libs.error import logging_exception
import logging
from libs.cache import redis_client
import json
from moment.views.send_email import send_email_tome


def follow(card_info):
    try:
        key = "auto_vest_one_user_action:" + str(card_info['card_id'])
        redis_data = redis_client.get(key)
        if redis_data:
            redis_data = json.loads(str(redis_data, encoding="utf8"))
            click_num = int(redis_data.get("follow")) + 1
            redis_data['follow'] = click_num
            redis_client.set(key, json.dumps(redis_data))
        else:
            redis_data = {"click": 0, "follow": 1, "comment": 0}
            redis_client.set(key, json.dumps(redis_data))
        redis_client.expire(key, time=24 * 60 * 60)
        logging.info("get action:follow,card_id:%s,redis_data:%s" % (card_info['card_id'], redis_data))

        follow_num = redis_data["follow"]

        if follow_num > 10:
            return True
            # send_email_tome(str(redis_data) + str(card_info))
        else:
            rpc_invoker = get_rpc_invoker()
            rpc_invoker['api/irrigation/user_add_follow'](follow_user_id=card_info['current_user_id'],
                                                          followed_user_id=card_info['card_user_id']).unwrap()
        # values = list(redis_data.values())
        # s = [True for i in values if i > 10]

        return True
    except:
        logging_exception()
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return False
