# -*- coding: UTF-8 -*-
import datetime
import time
import logging
from libs.error import logging_exception
import traceback
import random
from kafka import KafkaProducer
import random
from django.conf import settings
import json
from libs.cache import redis_client
from moment.views.get_keyword import GetContentKeyWords
import pymysql
from bs4 import BeautifulSoup

logger = logging.getLogger(__name__)
producer = KafkaProducer(bootstrap_servers=settings.KAFKA_BROKER_LIST)

db_zhengxing_eagle = pymysql.connect(host=settings.HOST, port=settings.PORT, user=settings.USER,
                                     password=settings.PASSWORD,
                                     db=settings.NAME)

zhengxing_cursor = db_zhengxing_eagle.cursor()


def strTimeProp(start, end, prop, frmt):
    stime = time.mktime(time.strptime(start, frmt))
    etime = time.mktime(time.strptime(end, frmt))
    ptime = stime + prop * (etime - stime)
    return int(ptime)


def randomDate(create_time, frmt='%Y-%m-%d %H:%M:%S', action_type=None):
    if action_type in ("follow", "click"):
        action_num = random.randint(1, 3)

    if action_type == "comment":
        action_num = random.randint(0, 1)

    start = str(create_time + datetime.timedelta(hours=2))
    end = str(create_time + datetime.timedelta(hours=4))

    random_times = [randomDate_six_one(start, end, frmt) for _ in range(action_num)]
    have_sort_times = sorted(random_times, key=lambda date: get_list(date))

    return have_sort_times


def randomDate_six_one(start, end, frmt='%Y-%m-%d %H:%M:%S'):
    return time.strftime(frmt, time.localtime(strTimeProp(start, end, random.random(), frmt)))


def get_list(date):
    return datetime.datetime.strptime(date, "%Y-%m-%d %H:%M:%S").timestamp()


def get_one_six_days_random_time(frmt='%Y-%m-%d %H:%M:%S', num_days=0, action_type=None, content_level=0,
                                 content_day_need_add_one_day=False):
    try:
        action_num = 0
        if num_days == 1 and action_type in ("follow", "click") and int(content_level) < 3:
            action_num = random.randint(1, 3)

        if num_days == 1 and action_type in ("follow") and int(content_level) >= 3:
            action_num = random.randint(5, 10)

        if num_days <= 15 and num_days > 1 and action_type in ("follow", "click") and int(content_level) < 3:
            action_num = random.randint(1, 2)

        if num_days <= 15 and num_days > 1 and action_type in ("follow") and int(content_level) >= 3:
            action_num = random.randint(1, 5)

        if num_days == 1 and action_type in ("click") and int(content_level) >= 3:
            action_num = random.randint(6, 12)

        if num_days <= 15 and num_days > 1 and action_type in ("click") and int(content_level) >= 3:
            action_num = random.randint(1, 6)

        if num_days >= 1 and num_days <= 6 and action_type in ("comment"):
            if int(content_level) <= 3:
                action_num = random.randint(1, 2)
            else:
                action_num = random.randint(2, 4)

        now = datetime.datetime.now()
        if content_day_need_add_one_day == True:
            nows = now
            now = nows + datetime.timedelta(days=1)

        zeroday = str(datetime.datetime(now.year, now.month, now.day, 10, 0, 0))
        lastday = str(datetime.datetime(now.year, now.month, now.day, 23, 0, 0))
        random_times = [randomDate_six_one(zeroday, lastday, frmt) for _ in range(action_num)]
        have_sort_times = sorted(random_times, key=lambda date: get_list(date))
        return have_sort_times
    except:
        logger.error("catch exception,err_log:%s" % traceback.format_exc())
        return []


def get_ten_last_days_random_time(num_days=None, frmt='%Y-%m-%d %H:%M:%S', content_level=0,
                                  content_day_need_add_one_day=False, action_type=None, repeat_time=1):
    try:

        if num_days == None:
            return []
        ##比较当前时间和最后一次创建时间的差
        now = datetime.datetime.now()
        zeroday = datetime.datetime(now.year, now.month, now.day, 10, 0, 0)
        lastday = datetime.datetime(now.year, now.month, now.day, 23, 0, 0)
        add_number = 0
        if num_days > 15 and action_type in ("follow"):
            action_num = random.randint(1, 2)
            add_number = 10

        elif num_days > 15 and action_type in ("click"):
            if content_level < 3:
                action_num = random.randint(1, 2)
                add_number = 6

            else:
                action_num = random.randint(1, 2)
                add_number = 5

        elif num_days > 6 and action_type in ("comment"):
            if content_level <= 3:
                action_num = 1
                add_number = 10
            else:
                action_num = random.randint(1, 2)
                add_number = 10

        else:
            pass

        if content_day_need_add_one_day == True:
            start_time = zeroday + datetime.timedelta(days=add_number * repeat_time)
            end_time = lastday + datetime.timedelta(days=add_number * repeat_time)

        else:
            start_time = zeroday + datetime.timedelta(days=add_number)
            end_time = lastday + datetime.timedelta(days=add_number)

        random_times = [randomDate_six_one(str(start_time), str(end_time), frmt) for _ in range(action_num)]
        have_sort_times = sorted(random_times, key=lambda date: get_list(date))

        return have_sort_times
    except:
        logger.error("catch exception,err_log:%s" % traceback.format_exc())
        return []


def get_content_time_by_create_time(create_time="", content_level=0, action_type=None, after_day=False, card_info=None,
                                    repeat_time=0):
    try:
        ###在这个地方需要重新判断一下星级
        # content_level = get_current_card_content_level(card_info)
        ##
        card_info['type'] = 'have_get_push_time'
        card_info['have_comment_number'] = 0
        now = datetime.datetime.now()
        createt = datetime.datetime.strptime(create_time, '%Y-%m-%d %H:%M:%S')
        num_days = (now - createt).days
        content_day_need_add_one_day = False
        if after_day == True and card_info is not None:
            num_days += repeat_time
            content_day_need_add_one_day = True

        # 创建时间切换成分钟数便于比较
        # mins = divmod(num, min)[0]
        ##根据转换后的分钟数进行比较
        ##转化成分数后进行一层一层的比较
        if num_days == 0:
            get_time = randomDate(create_time=createt, action_type=action_type)
            time_region = 0
            return get_time, time_region

        elif num_days >= 1 and num_days <= 6:
            get_time = get_one_six_days_random_time(content_level=content_level, num_days=num_days,
                                                    action_type=action_type,
                                                    content_day_need_add_one_day=content_day_need_add_one_day)
            time_region = 1
            return get_time, time_region

        elif num_days > 6 and num_days <= 365:
            get_time = get_ten_last_days_random_time(num_days=num_days, content_level=content_level,
                                                     content_day_need_add_one_day=content_day_need_add_one_day,
                                                     action_type=action_type, repeat_time=repeat_time)
            time_region = 2
            return get_time, time_region

        else:
            ##需要删掉kafka的数据不再进行下发
            return [], 3

    except:
        logger.error("catch exception,err_log:%s" % traceback.format_exc())
        return [], 5


def get_click_follow_time_by_create_time(create_time="", content_level=0, action_type=None, after_day=False,
                                         card_info=None, repeat_time=0):
    try:
        card_info['have_click_number'] = 0
        card_info['have_follow_number'] = 0
        now = datetime.datetime.now()
        createt = datetime.datetime.strptime(create_time, '%Y-%m-%d %H:%M:%S')
        nowt = now.strftime('%Y-%m-%d %H:%M:%S')
        ##获取创建时间和当前时间的相差秒数
        num_days = (now - createt).days
        content_day_need_add_one_day = False
        if after_day:
            num_days += repeat_time
            content_day_need_add_one_day = True

        if num_days == 0:
            get_time = randomDate(create_time=createt, action_type=action_type)

            return get_time, 0

        elif num_days == 1:
            get_time = get_one_six_days_random_time(num_days=num_days, action_type=action_type,
                                                    content_level=content_level,
                                                    content_day_need_add_one_day=content_day_need_add_one_day)

            return get_time, 1

        elif num_days > 1 and num_days <= 15:
            get_time = get_one_six_days_random_time(num_days=num_days, action_type=action_type,
                                                    content_level=content_level,
                                                    content_day_need_add_one_day=content_day_need_add_one_day)

            return get_time, 2

        elif num_days > 15 and num_days <= 365:
            ##需要删掉kafka的数据不再进行下发

            get_time = get_ten_last_days_random_time(num_days=num_days, action_type=action_type,
                                                     content_level=content_level,
                                                     content_day_need_add_one_day=content_day_need_add_one_day)

            return get_time, 4

        else:
            return [], 3
    except:
        logger.error("catch exception,err_log:%s" % traceback.format_exc())
        return [], 5


def save_data_to_kafka(card_info):
    try:
        topic = settings.KAFKA_TOPIC_NAME
        producer.send(topic, json.dumps(card_info).encode())
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())


def get_vest_userid(need_comment_num=0):
    user_list = []
    if need_comment_num:
        for i in range(0, need_comment_num):
            user_data = open("moment/views/vest_ids.txt", "r")
            for i in user_data.readlines():
                user_list.append(int(i.strip()))
        user_ids = random.sample(user_list, need_comment_num)
        return user_ids
    else:
        return 12345


def get_vest_userid_and_comment(need_comment_num=0, tag_names=[], card_id=0):
    try:

        ##先根据card_id回去内容提取关键字
        # logging.info("get settings.HOST:%s" % settings.HOST)
        # db_zhengxing_eagle = pymysql.connect(host=settings.HOST, port=settings.PORT, user=settings.USER,
        #                                      password=settings.PASSWORD,
        #                                      db=settings.NAME)
        #
        # logging.info("get db_zhengxing_eagle:%s" % db_zhengxing_eagle)
        # zhengxing_cursor = db_zhengxing_eagle.cursor()
        # sql = 'select content from api_answer where id = %s ' % (card_id)
        # zhengxing_cursor.execute(sql)
        # data = list(zhengxing_cursor.fetchall())
        # logging.info("get data:%s" % data)
        # zhengxing_cursor.close()
        # if len(data) > 0:
        #     soup = BeautifulSoup(data[0][0], 'html.parser')
        #     contents = soup.text
        #
        #     ck = GetContentKeyWords()
        #     keywords = ck.get_keywords(contents, len(ck.tag_list))
        #     if keywords:
        #         tag_names.append(keywords)

        if need_comment_num:
            all_comment_list = []
            redis_key = "vest_kyc_tag_content_data"
            all_keys = redis_client.hkeys(redis_key)
            all_keys_name = []
            for item in all_keys:
                all_keys_name.append(str(item, encoding="utf-8"))
            for item in tag_names:
                if item in all_keys_name:
                    service_closure_tags = redis_client.hget(redis_key, item)
                    closure_tags = json.loads(str(service_closure_tags, encoding="utf-8"))
                    all_comment_list.extend(closure_tags)
            if all_comment_list:
                content = random.sample(all_comment_list, need_comment_num)
            else:
                content = None

        else:
            content = None
        return content

    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return []


def judge_offset_partition_have_consum(offset=0, partition=0):
    """
    根据当前的offset和分区去判断数据是否已经被消费
    :param offset:
    :param partition:
    :return:
    """
    try:
        redis_list_data = set()
        key = "irrigation_partition_offset_have_consum:" + str(partition)
        redis_data = redis_client.get(key)
        if redis_data:
            redis_list_data = set(json.loads(str(redis_data, encoding="utf8")))
            if offset in redis_list_data:
                return False
        redis_list_data.add(offset)
        redis_client.set(key, json.dumps(list(redis_list_data)))
        return True
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return False


def get_current_card_content_level(card_info=[]):
    try:

        # 先根据card_id回去内容提取关键字

        sql = 'select content from api_answer where id = %s ' % (card_info['card_id'])
        # zhengxing_cursor.execute(sql)
        # data = list(zhengxing_cursor.fetchall())
        # logging.info("get data:%s" % data)
        # zhengxing_cursor.close()
        # if len(data) > 0:
        #     soup = BeautifulSoup(data[0][0], 'html.parser')
        #     contents = soup.text
        #
        #     ck = GetContentKeyWords()
        #     keywords = ck.get_keywords(contents, len(ck.tag_list))
        #     if keywords:
        #         tag_names.append(keywords)
        #
        # return tag_names

    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return []
