# -*- coding: UTF-8 -*-
import datetime
import logging
import traceback
import random
import time
from moment.views.process_time import get_content_time_by_create_time, get_vest_userid_and_comment, get_vest_userid
from moment.views.process_time import save_data_to_kafka
from libs.error import logging_exception

logger = logging.getLogger(__name__)


def auto_comment_user(card_info, after_day=False):
    """
    当天发布之后

    2-4小时内随机，给予[0-1]个评论

    对所有回答每天1次夜里24点轮询：

    1天-6天之间发的的回答：
    3星以下
    [0-1]个评论
    4星以上
    [2-4]个评论

    6天后，每10天：
    3星以下
    [0-1]个评论
    4星以上
    [0-2]个评论
    轮询时间-发布时间超过365天，终止加评论



    兜底:一天一人最多20条马甲评论，每条马甲评论的间隔时间40分钟-60分种。过24点清掉今天待发送队列。

    评论时间10-23点随机(对于非当天有效）
    随机马甲（运营给予一批马甲号，只使用这些马甲号）
    从马甲评论库（excel）里取评论
    覆盖所有发布回答的作者
    覆盖所有内容来源：后台创建、app创建
    """
    try:

        if card_info:
            ###先获取kafka的数据
            create_time = card_info["create_time"]
            content_level = card_info["content_level"]
            card_info["action_type"] = "comment"
            tag_names = card_info['tag_names']

            # 当满足这些条件的时候 代表已经完成了下发的所有的时间或者还没有下发过时间 需要给予新的时间
            if ("all_follow_id" in card_info and "all_push_time" in card_info and len(
                    card_info['all_follow_id']) == 0 and len(card_info['all_push_time']) == 0) or (
                    "all_follow_id" not in card_info and "all_push_time" not in card_info and card_info[
                'type'] == "get_write_answer_userinfo"):

                while True:

                    repeat_time = 1
                    if card_info['type'] == "get_write_answer_userinfo":
                        repeat_time = 0
                        card_info['have_comment_number'] = 0

                    get_time, time_region = get_content_time_by_create_time(create_time, content_level,
                                                                            action_type="comment",
                                                                            after_day=after_day,
                                                                            card_info=card_info,
                                                                            repeat_time=repeat_time)
                    logging.info("get get_time and time_region:%s" % get_time)
                    if len(get_time) > 0 and time_region != 3:
                        ###拿到下发时间后根据下发的时间个数去拿对应个数的马甲账号
                        all_content = get_vest_userid_and_comment(need_comment_num=len(get_time),
                                                                  tag_names=tag_names,
                                                                  card_id=card_info['card_id'])

                        userids = get_vest_userid(need_comment_num=len(get_time))
                        for i in range(0, len(userids)):
                            card_info["all_follow_id"] = userids
                            card_info["current_user_id"] = userids[0]
                            card_info['type'] = "have_get_push_time"
                            card_info['current_push_time'] = get_time[0]
                            card_info['all_push_time'] = get_time
                            card_info["need_pust_num"] = len(userids)
                            card_info["have_pust_num"] = 0
                            card_info["all_content"] = all_content
                            if len(all_content) > 0:
                                card_info['comment_content'] = all_content[0]
                        save_data_to_kafka(card_info)
                        break
                    else:
                        if time_region == 3:
                            break
                        repeat_time += 1

                logging.info("get have_get_after__time:%s" % card_info)
            else:  # 代表还有push好的时间没有下发完成 需要继续使用这些

                logging.info("get-------comment---------------card_info:%s" % card_info)
                current_user_id = card_info["current_user_id"]
                card_info["all_follow_id"].remove(current_user_id)
                current_push_time = card_info['current_push_time']
                card_info['all_push_time'].remove(current_push_time)
                card_info["have_pust_num"] = card_info["have_pust_num"] + 1

                comment_content = card_info["comment_content"]
                card_info["all_content"].remove(comment_content)

                if len(card_info["all_content"]) > 0:
                    card_info["comment_content"] = card_info["all_content"][0]
                    
                if len(card_info["all_follow_id"]) > 0:
                    card_info["current_user_id"] = card_info["all_follow_id"][0]

                if len(card_info["all_follow_id"]) > 0:
                    card_info['current_push_time'] = card_info['all_push_time'][0]

                save_data_to_kafka(card_info)  # 存储数据
                logging.info("get-------comment---------------card_info:%s" % card_info)

    except:
        logging_exception()
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
