#!/usr/bin/env python
# -*- coding: utf-8 -*-
import json
from kafka import KafkaProducer
from kafka import KafkaConsumer
from gm_rpcd.all import bind
import traceback
from django.conf import settings
from follow.views.auto_follow import auto_follow_user
from click.views.auto_click import auto_click_user
from comment.views.auto_comment import auto_comment_user
from moment.views.process_time import save_data_to_kafka
import datetime
import time
import logging
from libs.error import logging_exception
from click.views.click_fun import click
from comment.views.comment_fun import comment
from follow.views.follow_fun import follow


def kafka_consum(topic_name=None):
    topic_name = settings.KAFKA_TOPIC_NAME if not topic_name else topic_name
    consumser_obj = KafkaConsumer(topic_name, bootstrap_servers=[settings.KAFKA_BROKER_LIST], enable_auto_commit=False,
                                  auto_commit_interval_ms=100, group_id="vest")

    try:
        while True:
            msg_dict = consumser_obj.poll(timeout_ms=100, max_records=100)

            for msg_key in msg_dict:
                consume_msg = msg_dict[msg_key]
                for msg in consume_msg:
                    card_info = json.loads(msg.value)
                    if card_info['card_type'] == "auto_vest":
                        logging.info("+++++++++++++++++++++++++新的数据进来了+++++++++++++++++++++++")
                        logging.info("get card_info:%s" % card_info)
                        # 代表当天数据
                        current_push_time = card_info['current_push_time']
                        create_time = card_info['create_time']
                        nowtime = datetime.datetime.now()
                        push_time_date = datetime.datetime.strptime(current_push_time, '%Y-%m-%d %H:%M:%S')
                        if push_time_date <= nowtime:  # push_time已经到时间了 需要去下发
                            logging.info("get push_time_date:%s" % push_time_date)
                            # 判断如果当前的push_time 和当前的创建时间一样  需要给push_time下发真的push时间
                            if current_push_time == create_time:
                                if card_info['action_type'] == "comment":
                                    auto_comment_user(card_info, after_day=True)

                                elif card_info['action_type'] == "click":
                                    auto_click_user(card_info, after_day=True)

                                elif card_info['action_type'] == "follow":
                                    auto_follow_user(card_info, after_day=True)

                                else:
                                    pass

                            else:
                                # 当前已下发完 需要判断最新一次的下发时间是否是今天 是的话直接保存起来,l=轮询等待明天再下发
                                if card_info['have_pust_num'] == card_info['need_pust_num']:
                                    if nowtime.day - push_time_date.day == 0:  # 今日的已经下发完了，需要去取之后的
                                        action_type = card_info['action_type']
                                        logging.info("get-------今天已经下发完了----------------")
                                        if action_type == "comment":
                                            auto_comment_user(card_info, after_day=True)
                                        elif action_type == "click":
                                            auto_click_user(card_info, after_day=True)
                                        elif action_type == "follow":
                                            auto_follow_user(card_info, after_day=True)
                                        else:
                                            pass

                                else:  # 还有一种是下发时间已到
                                    action_type = card_info['action_type']

                                    if card_info['have_pust_num'] < card_info['need_pust_num'] and \
                                            push_time_date < nowtime:

                                        if action_type == "comment":  # 在这里去调评论的接口
                                            if 'have_comment_number' in card_info and \
                                                    card_info['have_comment_number'] < 20:
                                                card_info["have_comment_number"] += 1
                                                is_success = comment(card_info)
                                                logging.info("当前ID:%s，下发状状态:%s" % (card_info["card_id"], is_success))
                                                logging.info("get------xiafa------------vestcomment:%s" % card_info)

                                            # 调完接口后需要再次去拿新的push_time的时间
                                            auto_comment_user(card_info)

                                        elif action_type == "click":  # 在这里去调点赞的接口
                                            if 'have_click_number' in card_info and card_info['have_click_number'] < 20:
                                                card_info["have_click_number"] += 1
                                                is_success = click(card_info)
                                                logging.info("当前ID:%s，下发状状态:%s" % (card_info["card_id"], is_success))
                                                logging.info("get------xiafa------------vestclick:%s" % card_info)

                                            auto_click_user(card_info)

                                        elif action_type == "follow":  # 在这里去调关注的接口

                                            if 'have_follow_number' in card_info and \
                                                    card_info['have_follow_number'] < 20:
                                                card_info["have_follow_number"] += 1
                                                is_success = follow(card_info)
                                                logging.info("当前ID:%s，下发状状态:%s" % (card_info["card_id"], is_success))
                                                logging.info("get------xiafa------------vestfollow:%s" % card_info)

                                            auto_follow_user(card_info)

                        else:  # push_time时间未到 需要等待
                            logging.info("push_time时间未到========================需要等待")
                            save_data_to_kafka(card_info)
                            pass

                    consumser_obj.commit_async()
    except:
        consumser_obj.close()
        logging_exception()
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
