#!/usr/bin/env python
# -*- coding: utf-8 -*-
import json
from kafka import KafkaProducer
from kafka import KafkaConsumer
from gm_rpcd.all import bind
import traceback
from django.conf import settings
import datetime
import time
import logging
from libs.error import logging_exception


@bind('vest/moment/vest_irrigation')
def vest_irrigation(card_id=0, card_type=None, card_user_id=None, create_time="", content_level=0, tag_names=[]):
    try:

        producer = KafkaProducer(bootstrap_servers=[settings.KAFKA_BROKER_LIST])

        logging.info("------------------------")
        topic = settings.KAFKA_TOPIC_NAME

        tag_list = ["瘦脸针kyc", "双眼皮kyc", "水光针kyc", "玻尿酸kyc", "吸脂kyc", "祛痘kyc", "鼻综合kyc", "光子嫩肤kyc", "没有想法kyc",
                    "牙齿kyc", "抗衰紧致kyc", "胸部kyc", "果酸换肤kyc", "祛斑kyc", "美白针kyc", "瘦腿针kyc"]

        flag = False
        if len(tag_names) > 0:
            for i in tag_names:
                if i in tag_list:
                    flag = True

        if flag == True:
            comment_msg_dict = {
                "card_id": card_id,
                "card_type": "auto_vest",
                "create_time": create_time,
                "content_level": content_level,
                "tag_names": tag_names,
                "type": "get_write_answer_userinfo",
                "current_push_time": create_time,
                'action_type': 'comment'

            }
            logging.info("get comment_msg_dict:%s" % comment_msg_dict)
            producer.send(topic, json.dumps(comment_msg_dict).encode())

        follow_msg_dict = {
            "card_id": card_id,
            "card_type": "auto_vest",
            "create_time": create_time,
            "content_level": content_level,
            "tag_names": tag_names,
            "type": "get_write_answer_userinfo",
            "current_push_time": create_time,
            'action_type': 'follow',
            'card_user_id': card_user_id

        }
        producer.send(topic, json.dumps(follow_msg_dict).encode())

        click_msg_dict = {
            "card_id": card_id,
            "card_type": "auto_vest",
            "create_time": create_time,
            "content_level": content_level,
            "tag_names": tag_names,
            "type": "get_write_answer_userinfo",
            "current_push_time": create_time,
            'action_type': 'click'

        }
        producer.send(topic, json.dumps(click_msg_dict).encode())

        producer.close()
        logging.info("------------------------")

    except:
        logging_exception()
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
