from libs.rpc import get_rpc_invoker
import traceback
from libs.error import logging_exception
import logging
from libs.cache import redis_client
import json
from moment.views.send_email import send_email_tome
import datetime


def follow(card_info):
    try:
        key = 'have_reply_answer_follow:' + str(card_info['card_id'])
        redis_data = redis_client.get(key)
        if redis_data:
            datas = json.loads(str(redis_data, encoding="utf-8"))
            if card_info['current_user_id'] in datas:
                return False

            else:
                datas.append(card_info['current_user_id'])
                redis_client.set(key, json.dumps(datas))

        else:
            conent = [card_info['current_user_id']]
            redis_client.set(key, json.dumps(conent))

        today = datetime.datetime.now()
        str_today = str(today.year) + str(today.month) + str(today.day)
        key = "auto_vest_action_follow_answer:" + str(card_info['card_id'])
        redis_data = redis_client.hget(key, str_today)

        if redis_data:
            redis_data = json.loads(str(redis_data, encoding="utf8"))
            have_pust_num = int(redis_data.get('follow_have_pust_num', card_info['have_pust_num']))
            need_pust_num = int(redis_data.get('follow_need_pust_num', card_info['need_pust_num']))

            if have_pust_num > need_pust_num:
                return True

            else:
                redis_data['follow_have_pust_num'] = have_pust_num + 1
                redis_client.hset(key, str_today, json.dumps(redis_data))
        else:
            redis_data = {"follow_have_pust_num": card_info['have_pust_num'],
                          "follow_need_pust_num": card_info['need_pust_num']}

            redis_client.hset(key, str_today, json.dumps(redis_data))

        rpc_invoker = get_rpc_invoker()
        try:
            status = rpc_invoker['api/irrigation/user_add_follow'](follow_user_id=card_info['current_user_id'],
                                                                   followed_user_id=card_info[
                                                                       'card_user_id']).unwrap()

            error = status.get('error', 1)
            if error == 0:
                return True
            else:
                send_email_tome(str(card_info) + str(status))
                return False
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return False

    except:
        logging_exception()
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return False
