# -*- coding: UTF-8 -*-
import datetime
import time
import logging
from libs.error import logging_exception
import traceback
import random
from kafka import KafkaProducer
import random
from django.conf import settings
import json
from libs.cache import redis_client
from moment.views.get_keyword import GetContentKeyWords
import pymysql
from bs4 import BeautifulSoup

logger = logging.getLogger(__name__)
producer = KafkaProducer(bootstrap_servers=settings.KAFKA_BROKER_LIST)

db_mimas_eagle = pymysql.connect(host=settings.HOST, port=settings.PORT, user=settings.USER,
                                 password=settings.PASSWORD,
                                 db=settings.NAME)

mimas_cursor = db_mimas_eagle.cursor()

db_zhengxing_eagle = pymysql.connect(host=settings.HOST1, port=settings.PORT, user=settings.USER1,
                                     password=settings.PASSWORD1,
                                     db=settings.NAME1)

zhengxing_cursor = db_zhengxing_eagle.cursor()


def strTimeProp(start, end, prop, frmt):
    stime = time.mktime(time.strptime(start, frmt))
    etime = time.mktime(time.strptime(end, frmt))
    ptime = stime + prop * (etime - stime)
    return int(ptime)


def randomDate(create_time, frmt='%Y-%m-%d %H:%M:%S', action_type=None):
    if action_type in ("follow", "click"):
        action_num = random.randint(1, 3)

    if action_type == "comment":
        action_num = random.randint(1, 2)

    start = str(create_time + datetime.timedelta(minutes=30))
    end = str(create_time + datetime.timedelta(hours=2))

    random_times = [randomDate_six_one(start, end, frmt) for _ in range(action_num)]
    have_sort_times = sorted(random_times, key=lambda date: get_list(date))

    return have_sort_times


def randomDate_six_one(start, end, frmt='%Y-%m-%d %H:%M:%S'):
    return time.strftime(frmt, time.localtime(strTimeProp(start, end, random.random(), frmt)))


def get_list(date):
    return datetime.datetime.strptime(date, "%Y-%m-%d %H:%M:%S").timestamp()


def get_one_six_days_random_time(frmt='%Y-%m-%d %H:%M:%S', num_days=0, action_type=None, content_level=0,
                                 content_day_need_add_one_day=False):
    try:
        action_num = 0
        all_time_list = []
        ##follow 发布后1天 3：1-2  4：5-10
        ##
        if num_days == 1 and action_type in ("follow", "click") and int(content_level) < 3:
            action_num = random.randint(1, 2)

        if num_days == 1 and action_type in ("follow") and int(content_level) >= 3:
            action_num = random.randint(5, 10)

        if num_days == 1 and action_type in ("click") and int(content_level) >= 3:
            action_num = random.randint(6, 12)

        if num_days <= 15 and num_days > 1 and action_type in ("follow", "click") and int(content_level) < 3:
            action_num = random.randint(1, 2)

        if num_days <= 15 and num_days > 1 and action_type in ("follow") and int(content_level) >= 3:
            action_num = random.randint(1, 5)

        if num_days <= 15 and num_days > 1 and action_type in ("click") and int(content_level) >= 3:
            action_num = random.randint(1, 6)

        if num_days >= 1 and num_days <= 6 and action_type in ("comment"):
            if int(content_level) <= 3:
                action_num = random.randint(2, 4)
            else:
                action_num = random.randint(3, 4)

        now = datetime.datetime.now()
        if content_day_need_add_one_day == True:
            nows = now
            now = nows + datetime.timedelta(days=1)

        ##第一个时间段
        zeroday = str(datetime.datetime(now.year, now.month, now.day, 9, 0, 0))
        lastday = str(datetime.datetime(now.year, now.month, now.day, 10, 59, 59))
        random_times = [randomDate_six_one(zeroday, lastday, frmt) for _ in range(action_num)]
        have_sort_times1 = sorted(random_times, key=lambda date: get_list(date))

        ##第二个时间段
        zeroday = str(datetime.datetime(now.year, now.month, now.day, 12, 0, 0))
        lastday = str(datetime.datetime(now.year, now.month, now.day, 14, 59, 59))
        random_times = [randomDate_six_one(zeroday, lastday, frmt) for _ in range(action_num)]
        have_sort_times2 = sorted(random_times, key=lambda date: get_list(date))

        ##第三个时间段
        zeroday = str(datetime.datetime(now.year, now.month, now.day, 20, 0, 0))
        lastday = str(datetime.datetime(now.year, now.month, now.day, 23, 59, 59))
        random_times = [randomDate_six_one(zeroday, lastday, frmt) for _ in range(action_num)]
        have_sort_times3 = sorted(random_times, key=lambda date: get_list(date))

        all_time_list.extend(have_sort_times1)
        all_time_list.extend(have_sort_times2)
        all_time_list.extend(have_sort_times3)

        return all_time_list
    except:
        logger.error("catch exception,err_log:%s" % traceback.format_exc())
        return []


def get_ten_last_days_random_time(num_days=None, frmt='%Y-%m-%d %H:%M:%S', content_level=0,
                                  content_day_need_add_one_day=False, action_type=None, repeat_time=1):
    try:
        all_time_list = []
        if num_days == None:
            return []
        ##比较当前时间和最后一次创建时间的差
        now = datetime.datetime.now()
        zeroday = datetime.datetime(now.year, now.month, now.day, 9, 0, 0)

        add_number = 0
        if num_days > 15 and action_type in ("follow", "click"):
            action_num = random.randint(1, 2)
            add_number = 3

        elif num_days > 6 and action_type in ("comment"):
            if content_level <= 3:
                action_num = 1
                add_number = 3
            else:
                action_num = random.randint(1, 2)
                add_number = 3

        else:
            pass
        start_time = zeroday + datetime.timedelta(days=add_number)
        ##第一个时间段
        zeroday1 = str(datetime.datetime(start_time.year, start_time.month, start_time.day, 9, 0, 0))
        lastday1 = str(datetime.datetime(start_time.year, start_time.month, start_time.day, 10, 59, 59))
        random_times = [randomDate_six_one(zeroday1, lastday1, frmt) for _ in range(action_num)]
        have_sort_times1 = sorted(random_times, key=lambda date: get_list(date))

        ##第二个时间段
        zeroday2 = str(datetime.datetime(start_time.year, start_time.month, start_time.day, 12, 0, 0))
        lastday2 = str(datetime.datetime(start_time.year, start_time.month, start_time.day, 14, 59, 59))
        random_times = [randomDate_six_one(zeroday2, lastday2, frmt) for _ in range(action_num)]
        have_sort_times2 = sorted(random_times, key=lambda date: get_list(date))

        ##第三个时间段
        zeroday3 = str(datetime.datetime(start_time.year, start_time.month, start_time.day, 20, 0, 0))
        lastday3 = str(datetime.datetime(start_time.year, start_time.month, start_time.day, 23, 59, 59))
        random_times = [randomDate_six_one(zeroday3, lastday3, frmt) for _ in range(action_num)]
        have_sort_times3 = sorted(random_times, key=lambda date: get_list(date))

        all_time_list.extend(have_sort_times1)
        all_time_list.extend(have_sort_times2)
        all_time_list.extend(have_sort_times3)

        # if content_day_need_add_one_day == True:
        #     start_time = zeroday + datetime.timedelta(days=add_number * repeat_time)
        #     end_time = lastday + datetime.timedelta(days=add_number * repeat_time)
        #
        # else:
        #     start_time = zeroday + datetime.timedelta(days=add_number)
        #     end_time = lastday + datetime.timedelta(days=add_number)

        # random_times = [randomDate_six_one(str(start_time), str(end_time), frmt) for _ in range(action_num)]
        # have_sort_times = sorted(random_times, key=lambda date: get_list(date))

        return all_time_list
    except:
        logger.error("catch exception,err_log:%s" % traceback.format_exc())
        return []


def get_content_time_by_create_time(create_time="", content_level=0, action_type=None, after_day=False, card_info=None,
                                    repeat_time=0):
    try:
        ###在这个地方需要重新判断一下星级
        content_level = get_current_card_content_level(card_info)
        card_info['content_level'] = content_level
        ##
        card_info['type'] = 'have_get_push_time'
        card_info['have_comment_number'] = 0
        now = datetime.datetime.now()
        createt = datetime.datetime.strptime(create_time, '%Y-%m-%d %H:%M:%S')
        num_days = (now - createt).days
        content_day_need_add_one_day = False
        if after_day == True and card_info is not None:
            num_days += repeat_time
            content_day_need_add_one_day = True

        if num_days >= 0 and num_days <= 6:
            if num_days == 0:
                num_days = 1
            get_time = get_one_six_days_random_time(content_level=content_level, num_days=num_days,
                                                    action_type=action_type,
                                                    content_day_need_add_one_day=content_day_need_add_one_day)
            time_region = 1
            return get_time, time_region

        elif num_days > 6 and num_days <= 365:
            get_time = get_ten_last_days_random_time(num_days=num_days, content_level=content_level,
                                                     content_day_need_add_one_day=content_day_need_add_one_day,
                                                     action_type=action_type, repeat_time=repeat_time)
            time_region = 2
            return get_time, time_region

        else:
            ##需要删掉kafka的数据不再进行下发
            return [], 3

    except:
        logger.error("catch exception,err_log:%s" % traceback.format_exc())
        return [], 5


def get_click_follow_time_by_create_time(create_time="", content_level=0, action_type=None, after_day=False,
                                         card_info=None, repeat_time=0):
    try:
        ######在这个地方需要重新判断一下星级
        content_level = get_current_card_content_level(card_info)
        card_info['content_level'] = content_level
        ####
        card_info['have_click_number'] = 0
        card_info['have_follow_number'] = 0
        now = datetime.datetime.now()
        createt = datetime.datetime.strptime(create_time, '%Y-%m-%d %H:%M:%S')
        nowt = now.strftime('%Y-%m-%d %H:%M:%S')
        ##获取创建时间和当前时间的相差秒数
        num_days = (now - createt).days
        content_day_need_add_one_day = False
        if after_day:
            num_days += repeat_time
            content_day_need_add_one_day = True

        if num_days == 0 or num_days == 1:
            num_days = 1
            get_time = get_one_six_days_random_time(num_days=num_days, action_type=action_type,
                                                    content_level=content_level,
                                                    content_day_need_add_one_day=content_day_need_add_one_day)

            return get_time, 1

        elif num_days > 1 and num_days <= 15:
            get_time = get_one_six_days_random_time(num_days=num_days, action_type=action_type,
                                                    content_level=content_level,
                                                    content_day_need_add_one_day=content_day_need_add_one_day)

            return get_time, 2

        elif num_days > 15 and num_days <= 365:
            ##需要删掉kafka的数据不再进行下发

            get_time = get_ten_last_days_random_time(num_days=num_days, action_type=action_type,
                                                     content_level=content_level,
                                                     content_day_need_add_one_day=content_day_need_add_one_day)

            return get_time, 4

        else:
            return [], 3
    except:
        logger.error("catch exception,err_log:%s" % traceback.format_exc())
        return [], 5


def save_data_to_kafka(card_info):
    try:
        topic = settings.KAFKA_TOPIC_NAME
        producer.send(topic, json.dumps(card_info).encode())
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())


def get_vest_userid(need_comment_num=0):
    user_list = []
    if need_comment_num:
        for i in range(0, need_comment_num):
            user_data = open("moment/views/vest_ids.txt", "r")
            for i in user_data.readlines():
                user_list.append(int(i.strip()))
        user_ids = random.sample(user_list, need_comment_num)
        return user_ids
    else:
        return 12345


def get_vest_userid_and_comment(need_comment_num=0, tag_names=[], card_id=0):
    try:

        ##先根据card_id回去内容提取关键字
        # logging.info("get settings.HOST:%s" % settings.HOST)
        # db_zhengxing_eagle = pymysql.connect(host=settings.HOST, port=settings.PORT, user=settings.USER,
        #                                      password=settings.PASSWORD,
        #                                      db=settings.NAME)
        #
        # logging.info("get db_zhengxing_eagle:%s" % db_zhengxing_eagle)
        # zhengxing_cursor = db_zhengxing_eagle.cursor()
        # sql = 'select content from api_answer where id = %s ' % (card_id)
        # zhengxing_cursor.execute(sql)
        # data = list(zhengxing_cursor.fetchall())
        # logging.info("get data:%s" % data)
        # zhengxing_cursor.close()
        # if len(data) > 0:
        #     soup = BeautifulSoup(data[0][0], 'html.parser')
        #     contents = soup.text
        #
        #     ck = GetContentKeyWords()
        #     keywords = ck.get_keywords(contents, len(ck.tag_list))
        #     if keywords:
        #         tag_names.append(keywords)

        if need_comment_num:
            all_comment_list = []
            redis_key = "vest_kyc_tag_content_data"
            all_keys = redis_client.hkeys(redis_key)
            all_keys_name = []
            for item in all_keys:
                all_keys_name.append(str(item, encoding="utf-8"))
            for item in tag_names:
                if item in all_keys_name:
                    service_closure_tags = redis_client.hget(redis_key, item)
                    closure_tags = json.loads(str(service_closure_tags, encoding="utf-8"))
                    all_comment_list.extend(closure_tags)
            if all_comment_list:
                content = random.sample(all_comment_list, need_comment_num)
            else:
                content = []

        else:
            content = []
        return content

    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return []


def judge_offset_partition_have_consum(card_info=None, offset=0, partition=0):
    """
    根据当前的offset和分区去判断数据是否已经被消费
    :param offset:
    :param partition:
    :return:
    """
    try:
        ##先判断是不是2019-12-29的
        create_time = card_info['create_time']
        datetime_create_time = datetime.datetime.strptime(create_time, '%Y-%m-%d %H:%M:%S')
        str_data = str(datetime_create_time.year) + str(datetime_create_time.month) + str(datetime_create_time.day)
        if str_data in ['20191229', '20191230']:
            return False

        redis_list_data = 0
        key = "irrigation_partition_offset_have_consum:" + str(partition)
        redis_data = redis_client.get(key)
        if offset < int(redis_data):
            return False
        redis_client.set(key, offset)
        return True
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return False


def judge_data_have_in_redis(card_info=None):
    try:

        today = datetime.datetime.now()
        str_today = str(today.year) + str(today.month) + str(today.day)
        push_time = card_info['current_push_time']
        push_datetime = datetime.datetime.strptime(push_time, '%Y-%m-%d %H:%M:%S')
        str_push_datetime = str(push_datetime.year) + str(push_datetime.month) + str(push_datetime.day)

        if str_today != str_push_datetime:
            return True

        if card_info['action_type'] == 'comment':
            ##在这里加一个判断  如果当前的评论的user_id和评论内容已经在这个评论下了就不再下发给同一个回答ID
            key = 'have_reply_answer_comment:' + str(card_info['card_id'])
            redis_data = redis_client.hget(key, card_info['current_user_id'])
            if redis_data:
                datas = json.loads(str(redis_data, encoding="utf-8"))
                if card_info['comment_content'] in datas:
                    return False

                else:
                    datas.append(card_info['comment_content'])
                    redis_client.hset(key, card_info['current_user_id'], json.dumps(datas))
                    return True

            else:
                conent = [card_info['comment_content']]
                redis_client.hset(key, card_info['current_user_id'], json.dumps(conent))
                return True

        elif card_info['action_type'] == 'follow':

            key = 'have_reply_answer_follow:' + str(card_info['card_id'])
            redis_data = redis_client.get(key)
            if redis_data:
                datas = json.loads(str(redis_data, encoding="utf-8"))
                if card_info['current_user_id'] in datas:
                    return False

                else:
                    datas.append(card_info['current_user_id'])
                    redis_client.set(key, json.dumps(datas))
                    return True

            else:
                conent = [card_info['current_user_id']]
                redis_client.set(key, json.dumps(conent))
                return True

        elif card_info['action_type'] == 'click':
            key = 'have_reply_answer_click:' + str(card_info['card_id'])
            redis_data = redis_client.get(key)
            if redis_data:
                datas = json.loads(str(redis_data, encoding="utf-8"))
                if card_info['current_user_id'] in datas:
                    return False

                else:
                    datas.append(card_info['current_user_id'])
                    redis_client.set(key, json.dumps(datas))
                    return True

            else:
                conent = [card_info['current_user_id']]
                redis_client.set(key, json.dumps(conent))
                return True

        else:
            pass
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return False


def get_current_card_content_level(card_info=[]):
    try:
        # 判断当前卡片的等级
        if card_info['card_status'] == 'answer':
            sql = 'select level from api_answer where id = %s ' % (card_info['card_id'])
            mimas_cursor.execute(sql)
            data = list(mimas_cursor.fetchall())

        if card_info['card_status'] == 'tractate':
            sql = 'select content_level from api_tractate where id = %s ' % (card_info['card_id'])
            mimas_cursor.execute(sql)
            data = list(mimas_cursor.fetchall())

        if card_info['card_status'] == 'diary':
            sql = 'select content_level from api_diary where id = %s ' % (card_info['card_id'])
            zhengxing_cursor.execute(sql)
            data = list(zhengxing_cursor.fetchall())

        if len(data) > 0:
            if data[0][0]:
                return int(data[0][0])
            else:
                return 0
        else:
            return 0

    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return 0
