from libs.rpc import get_rpc_invoker
import traceback
from libs.error import logging_exception
import logging
from libs.cache import redis_client
import json
from moment.views.send_email import send_email_tome
import datetime


def click(card_info):
    try:

        today = datetime.datetime.now()
        str_today = str(today.year) + str(today.month) + str(today.day)
        key = "auto_vest_one_user_action_answer:" + str(card_info['card_id'])
        redis_data = redis_client.hget(key, str_today)

        if redis_data:
            redis_data = json.loads(str(redis_data, encoding="utf8"))
            click_num = int(redis_data.get("click")) + 1
            redis_data['click'] = click_num
            redis_client.hset(key, str_today, json.dumps(redis_data))
        else:
            ##代表还没有存储或者是已经过去一天了 需要清掉数据 从新的一天开始
            redis_client.delete(key)
            redis_data = {"click": 1, "follow": 0, "comment": 0}
            redis_client.hset(key, str_today, json.dumps(redis_data))

        logging.info("get action:click,card_id:%s,redis_data:%s" % (card_info['card_id'], redis_data))
        click_num = redis_data["click"]

        if click_num > 10:
            return True
            # send_email_tome(str(redis_data) + str(card_info))
        else:
            rpc_invoker = get_rpc_invoker()
            rpc_invoker['qa/irrigation/create_answer_vote'](user_id=card_info['current_user_id'],
                                                            answer_id=card_info['card_id']).unwrap()
        return True
    except:
        logging_exception()
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return False
