from libs.rpc import get_rpc_invoker
import traceback
from libs.error import logging_exception
import logging
from libs.cache import redis_client
import json
from moment.views.send_email import send_email_tome
import datetime


def comment(card_info):
    """
    在这里需要判断是帖子下发评论还是问答还是日记下发
    :param card_info:
    :return:
    """
    try:
        if card_info['card_status'] == 'tractate':
            today = datetime.datetime.now()
            str_today = str(today.year) + str(today.month) + str(today.day)
            key = "auto_vest_one_user_action_tractate:" + str(card_info['card_id'])
            redis_data = redis_client.hget(key, str_today)

            if redis_data:
                redis_data = json.loads(str(redis_data, encoding="utf8"))
                click_num = int(redis_data.get("comment")) + 1
                redis_data['comment'] = click_num
                redis_client.hset(key, str_today, json.dumps(redis_data))
            else:
                ##代表还没有存储或者是已经过去一天了 需要清掉数据 从新的一天开始
                redis_client.delete(key)
                redis_data = {"comment": 1}
                redis_client.hset(key, str_today, json.dumps(redis_data))

            logging.info("get action:comment,card_id:%s,redis_data:%s" % (card_info['card_id'], redis_data))
            comment_num = redis_data["comment"]

            ####在这里做判断 一天不能超过20个 如果超过二十个不下发  不超过二十个下发对应的灌水功能
            if comment_num > 12:
                return True
                # send_email_tome(str(redis_data) + str(card_info))
            else:
                rpc_invoker = get_rpc_invoker()
                rpc_invoker['qa/irrigation/create_answer_reply'](user_id=card_info['current_user_id'],
                                                                 answer_id=card_info['card_id'],
                                                                 content=card_info['comment_content']).unwrap()

        elif card_info['card_status'] == 'diary':
            today = datetime.datetime.now()
            str_today = str(today.year) + str(today.month) + str(today.day)
            key = "auto_vest_one_user_action_diary:" + str(card_info['card_id'])
            redis_data = redis_client.hget(key, str_today)

            if redis_data:
                redis_data = json.loads(str(redis_data, encoding="utf8"))
                click_num = int(redis_data.get("comment")) + 1
                redis_data['comment'] = click_num
                redis_client.hset(key, str_today, json.dumps(redis_data))
            else:
                redis_client.delete(key)
                redis_data = {"comment": 1}
                redis_client.hset(key, str_today, json.dumps(redis_data))

            logging.info("get action:comment,card_id:%s,redis_data:%s" % (card_info['card_id'], redis_data))
            comment_num = redis_data["comment"]

            ####在这里做判断 一天不能超过20个 如果超过二十个不下发  不超过二十个下发对应的灌水功能
            if comment_num > 12:
                return True
                # send_email_tome(str(redis_data) + str(card_info))
            else:
                print("diary")
                rpc_invoker = get_rpc_invoker()
                rpc_invoker['qa/irrigation/create_answer_reply'](user_id=card_info['current_user_id'],
                                                                 answer_id=card_info['card_id'],
                                                                 content=card_info['comment_content']).unwrap()
        else:
            today = datetime.datetime.now()
            str_today = str(today.year) + str(today.month) + str(today.day)
            key = "auto_vest_one_user_action_answer:" + str(card_info['card_id'])
            redis_data = redis_client.hget(key, str_today)

            if redis_data:
                redis_data = json.loads(str(redis_data, encoding="utf8"))
                click_num = int(redis_data.get("comment")) + 1
                redis_data['comment'] = click_num
                redis_client.hset(key, str_today, json.dumps(redis_data))

            else:
                redis_client.delete(key)
                redis_data = {"click": 0, "follow": 0, "comment": 1}
                redis_client.hset(key, str_today, json.dumps(redis_data))

            logging.info("get action:comment,card_id:%s,redis_data:%s" % (card_info['card_id'], redis_data))
            comment_num = redis_data["comment"]

            ####在这里做判断 一天不能超过20个 如果超过二十个不下发  不超过二十个下发对应的灌水功能
            if comment_num > 12:
                return True
                # send_email_tome(str(redis_data) + str(card_info))
            else:
                print("answer")

                # rpc_invoker = get_rpc_invoker()
                # rpc_invoker['qa/irrigation/create_answer_reply'](user_id=card_info['current_user_id'],
                #                                                  answer_id=card_info['card_id'],
                #                                                  content=card_info['comment_content']).unwrap()
        return True
    except:
        logging_exception()
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return False
