#!/usr/bin/env python
# -*- coding: utf-8 -*-
from django.core.management.base import BaseCommand
import traceback
import logging
from moment.views.consum import kafka_consum
from libs.error import logging_exception

logger = logging.getLogger('async_debug')


class Command(BaseCommand):
    args = ''
    help = 'dump data to elasticsearch, parallel'

    from optparse import make_option

    option_list = BaseCommand.option_list + (
        make_option('-t', '--type', dest='type', help='type name to dump data to elasticsearch', metavar='TYPE',
                    default=''),
        make_option('-i', '--index-prefix', dest='index_prefix', help='index name to dump data to elasticsearch',
                    metavar='INDEX_PREFIX'),
        make_option('-p', '--parallel', dest='parallel', help='parallel process count', metavar='PARALLEL'),
        make_option('-s', '--pks', dest='pks', help='specify sync pks, comma separated', metavar='PKS', default=''),
        make_option('--streaming-slicing', dest='streaming_slicing', action='store_true', default=True),
        make_option('--no-streaming-slicing', dest='streaming_slicing', action='store_false', default=True),
        make_option('-S', '--sync_type', dest='sync_type', help='sync data to es', metavar='TYPE', default='')
    )

    def handle(self, *args, **options):
        try:
            if len(options["sync_type"]) and options["sync_type"] == "auto_vest":
                kafka_consum()
                logging.info("add a log >>>>>  auto_vest")

        except:
            logging_exception()
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
