from libs.rpc import get_rpc_invoker
import traceback
from libs.error import logging_exception
import logging
from libs.cache import redis_client
import json
from moment.views.send_email import send_email_tome


def comment(card_info):
    """
    在这个地方需要区分卡片的类型去调用不同的接口
    :param card_info:
    :return:
    """
    try:
        rpc_invoker = get_rpc_invoker()
        ##如果是回答
        if card_info['type_status'] == 'answer':
            key = "auto_vest_one_user_action:" + str(card_info['card_id'])
            redis_data = redis_client.get(key)
            if redis_data:
                redis_data = json.loads(redis_data)
                click_num = int(redis_data.get("comment")) + 1
                redis_data['comment'] = click_num
                redis_client.set(key, json.dumps(redis_data))
            else:
                redis_data = {"click": 0, "follow": 0, "comment": 1}
                redis_client.set(key, json.dumps(redis_data))
            redis_client.expire(key, time=24 * 60 * 60)

            logging.info("get action:comment,card_id:%s,redis_data:%s" % (card_info['card_id'], redis_data))
            comment_num = redis_data["comment"]
            ####在这里做判断 一天不能超过20个 如果超过二十个不下发  不超过二十个下发对应的灌水功能
            if comment_num > 20:
                send_email_tome(str(redis_data) + str(card_info))
            else:

                rpc_invoker['qa/irrigation/create_answer_reply'](user_id=card_info['current_user_id'],
                                                                 answer_id=card_info['card_id'],
                                                                 content=card_info['comment_content']).unwrap()
        if card_info['type_status'] == 'tractate':
            key = "auto_vest_one_user_action_tractate:" + str(card_info['card_id'])
            redis_data = redis_client.get(key)
            if redis_data:
                redis_data = json.loads(redis_data)
                click_num = int(redis_data.get("comment")) + 1
                redis_data['comment'] = click_num
                redis_client.set(key, json.dumps(redis_data))
            else:
                redis_data = {"comment": 1}
                redis_client.set(key, json.dumps(redis_data))
            redis_client.expire(key, time=24 * 60 * 60)

            logging.info("get action:comment,card_id:%s,redis_data:%s" % (card_info['card_id'], redis_data))

            comment_num = redis_data["comment"]
            ####在这里做判断 一天不能超过20个 如果超过二十个不下发  不超过二十个下发对应的灌水功能
            if comment_num > 20:
                send_email_tome(str(redis_data) + str(card_info))
            else:
                rpc_invoker['qa/irrigation/create_tractate_reply'](user_id=card_info['current_user_id'],
                                                                   answer_id=card_info['card_id'],
                                                                   content=card_info['comment_content']).unwrap()

        if card_info['type_status'] == 'diary':
            key = "auto_vest_one_user_action_diary:" + str(card_info['card_id'])
            redis_data = redis_client.get(key)
            if redis_data:
                redis_data = json.loads(redis_data)
                click_num = int(redis_data.get("comment")) + 1
                redis_data['comment'] = click_num
                redis_client.set(key, json.dumps(redis_data))
            else:
                redis_data = {"comment": 1}
                redis_client.set(key, json.dumps(redis_data))
            redis_client.expire(key, time=24 * 60 * 60)

            logging.info("get action:comment,card_id:%s,redis_data:%s" % (card_info['card_id'], redis_data))

            comment_num = redis_data["comment"]
            ####在这里做判断 一天不能超过20个 如果超过二十个不下发  不超过二十个下发对应的灌水功能
            if comment_num > 20:
                send_email_tome(str(redis_data) + str(card_info))
            else:
                rpc_invoker['qa/irrigation/create_diary_reply'](user_id=card_info['current_user_id'],
                                                                answer_id=card_info['card_id'],
                                                                content=card_info['comment_content']).unwrap()

        return True
    except:
        logging_exception()
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return False
