# -*- coding: UTF-8 -*-
import datetime
import logging
import traceback
import random
import time
from moment.views.process_time import get_content_time_by_create_time, get_click_follow_time_by_create_time, \
    get_vest_userid
from moment.views.process_time import save_data_to_kafka
from libs.error import logging_exception

logger = logging.getLogger(__name__)


def auto_follow_user(card_info, after_day=False):
    """
    灌水功能下发关注
    发帖后2小时：[1-3]个粉丝
    对所有回答每天1次轮询：
    3星以下：
    1天前发的回答：[1-3]个粉丝
    2-15天前发的回答：[0-1]个粉丝
    15天前或更早发的回答：每隔10天[0-2]个粉丝
    2. 3星以上：

    1天前发的回答：[5-10]个粉丝
    前2-15天发的回答：[0-5]个粉丝
    15天前或更早发的回答：每隔10天[0-2]个粉丝

    3.轮询时间-发布时间超过365天，终止加粉
    加粉兜底：每天每个人最多涨20个马甲粉丝

    10-23点随机(对于非当天有效）
    随机马甲（运营给予一批马甲号，只使用这些马甲号）
    :param card_info:
    :return:
    """
    try:

        if card_info:
            ###先获取kafka的数据
            create_time = card_info["create_time"]
            content_level = card_info["content_level"]
            card_info["action_type"] = "follow"

            # 当满足这些条件的时候 代表已经完成了下发的所有的时间或者还没有下发过时间 需要给予新的时间
            if ("all_follow_id" in card_info and "all_push_time" in card_info and len(
                    card_info['all_follow_id']) == 0 and len(card_info['all_push_time']) == 0) or (
                    "all_follow_id" not in card_info and "all_push_time" not in card_info):

                ###根据创建时间回答等级去获取对应的下发时间
                repeat_time = 1
                while True:
                    if card_info['type'] == "get_write_answer_userinfo":
                        repeat_time = 0
                        card_info['have_follow_number'] = 0

                    get_time, time_region = get_click_follow_time_by_create_time(create_time, content_level,
                                                                                 action_type="follow",
                                                                                 after_day=after_day,
                                                                                 card_info=card_info,
                                                                                 repeat_time=repeat_time)

                    if len(get_time) > 0 and time_region != 3:

                        ###拿到下发时间后根据下发的时间个数去拿对应个数的马甲账号
                        userids = get_vest_userid(need_comment_num=len(get_time))
                        for i in range(0, len(userids)):
                            card_info["all_follow_id"] = userids
                            card_info["current_user_id"] = userids[0]
                            card_info['type'] = "have_get_push_time"
                            card_info['current_push_time'] = get_time[0]
                            card_info['all_push_time'] = get_time
                            card_info["need_pust_num"] = len(userids)
                            card_info["have_pust_num"] = 0
                        save_data_to_kafka(card_info)
                        break
                    else:
                        if time_region == 3:
                            break
                        repeat_time += 1
            else:  # 代表还有push好的时间没有下发完成 需要继续使用这些
                card_info["have_pust_num"] = card_info["have_pust_num"] + 1
                current_user_id = card_info["current_user_id"]
                card_info["all_follow_id"].remove(current_user_id)
                current_push_time = card_info['current_push_time']
                card_info['all_push_time'].remove(current_push_time)

                if len(card_info["all_follow_id"]) > 0:
                    card_info["current_user_id"] = card_info["all_follow_id"][0]

                if len(card_info["all_follow_id"]) > 0:
                    card_info['current_push_time'] = card_info['all_push_time'][0]

                logging.info("get-------comment---------------card_info:%s" % card_info)
                save_data_to_kafka(card_info)  # 存储数据

    except:
        logging_exception()
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
