from libs.rpc import get_rpc_invoker
import traceback
from libs.error import logging_exception
import logging
from libs.cache import redis_client
import json
from moment.views.send_email import send_email_tome
import datetime
from moment.views.process_time import get_vest_userid_and_comment


def comment(card_info):
    """
    在这里需要判断是帖子下发评论还是问答还是日记下发
    :param card_info:
    :return:
    """
    try:
        if card_info['card_status'] == 'tractate':
            today = datetime.datetime.now()
            str_today = str(today.year) + str(today.month) + str(today.day)
            key = "auto_vest_one_user_action_tractate:" + str(card_info['card_id'])
            redis_data = redis_client.hget(key, str_today)

            if redis_data:
                redis_data = json.loads(str(redis_data, encoding="utf8"))
                click_num = int(redis_data.get("comment")) + 1
                redis_data['comment'] = click_num
                redis_client.hset(key, str_today, json.dumps(redis_data))
            else:
                ##代表还没有存储或者是已经过去一天了 需要清掉数据 从新的一天开始
                redis_client.delete(key)
                redis_data = {"comment": 1}
                redis_client.hset(key, str_today, json.dumps(redis_data))

            logging.info("get action:comment,card_id:%s,redis_data:%s" % (card_info['card_id'], redis_data))
            comment_num = redis_data["comment"]

            if comment_num > 12:
                logging.info("今天已经消费到最大次数了，不能再消费")
            else:
                try:
                    rpc_invoker = get_rpc_invoker()
                    status = rpc_invoker['qa/irrigation/create_answer_reply'](user_id=card_info['current_user_id'],
                                                                              answer_id=card_info['card_id'],
                                                                              content=card_info[
                                                                                  'comment_content']).unwrap()
                    logging.info("get_card_info:%s,have_answer_reply:%s" % (card_info, status))
                    error = status.get('error', 1)
                    if error == 0 and comment_num <= 11:
                        return True, True
                    elif error == 0 and comment_num > 11:
                        return True, False
                    else:
                        send_email_tome(str(card_info) + str(status))
                        return False, False
                except:
                    logging.error("catch exception,err_msg:%s" % traceback.format_exc())
                    return False, False

        elif card_info['card_status'] == 'diary':
            today = datetime.datetime.now()
            str_today = str(today.year) + str(today.month) + str(today.day)
            key = "auto_vest_one_user_action_diary:" + str(card_info['card_id'])
            redis_data = redis_client.hget(key, str_today)

            if redis_data:
                redis_data = json.loads(str(redis_data, encoding="utf8"))
                click_num = int(redis_data.get("comment")) + 1
                redis_data['comment'] = click_num
                redis_client.hset(key, str_today, json.dumps(redis_data))
            else:
                redis_client.delete(key)
                redis_data = {"comment": 1}
                redis_client.hset(key, str_today, json.dumps(redis_data))

            logging.info("get action:comment,card_id:%s,redis_data:%s" % (card_info['card_id'], redis_data))
            comment_num = redis_data["comment"]

            if comment_num > 12:
                logging.info("今天已经消费到最大次数了，不能再消费")
            else:
                try:
                    rpc_invoker = get_rpc_invoker()
                    status = rpc_invoker['qa/irrigation/create_answer_reply'](user_id=card_info['current_user_id'],
                                                                              answer_id=card_info['card_id'],
                                                                              content=card_info[
                                                                                  'comment_content']).unwrap()
                    logging.info("get_card_info:%s,have_answer_reply:%s" % (card_info, status))
                    error = status.get('error', 1)
                    if error == 0:
                        return True
                    else:
                        send_email_tome(str(card_info) + str(status))
                        return False
                except:
                    logging.error("catch exception,err_msg:%s" % traceback.format_exc())
                    return False

        else:

            ###判断一下如果评论为空就重新拿一个
            if not card_info['comment_content']:
                comment = get_vest_userid_and_comment(need_comment_num=1, tag_names=card_info['tag_names'])[0]
                card_info['comment_content'] = comment

            ##在这里加一个判断  如果当前的评论的user_id和评论内容已经在这个评论下了就不再下发给同一个回答ID
            else:
                key = 'have_reply_answer_comment:' + str(card_info['card_id'])
                redis_data = redis_client.hget(key, card_info['current_user_id'])
                if redis_data:
                    datas = json.loads(str(redis_data, encoding="utf-8"))
                    if card_info['comment_content'] in datas:
                        logging.info("当前评论和当前的用户已经存在了")
                        return True

                    else:
                        datas.append(card_info['comment_content'])
                        redis_client.hset(key, card_info['current_user_id'], json.dumps(datas))

                else:
                    conent = [card_info['comment_content']]
                    redis_client.hset(key, card_info['current_user_id'], json.dumps(conent))

            ####当天下发的次数存起来，每次下发判断已经下发了多少个 如果当前下发相等不再下发
            today = datetime.datetime.now()
            str_today = str(today.year) + str(today.month) + str(today.day)
            key = "auto_vest_action_comment_answer:" + str(card_info['card_id'])
            redis_data = redis_client.hget(key, str_today)

            if redis_data:
                redis_data = json.loads(str(redis_data, encoding="utf8"))
                have_pust_num = int(redis_data.get('comment_have_pust_num', card_info['have_pust_num']))
                need_pust_num = int(redis_data.get('comment_need_pust_num', card_info['need_pust_num']))

                if have_pust_num > need_pust_num:
                    logging.info("当前下发次数:%s已经达上限%s次，不能再下发:%s" % (have_pust_num, need_pust_num, card_info))
                    return True

                else:
                    redis_data['comment_have_pust_num'] = have_pust_num + 1
                    redis_client.hset(key, str_today, json.dumps(redis_data))
                    logging.info("当前下发次数:%s,上限是%s次，可以下发:%s" % (have_pust_num, need_pust_num, card_info))

            else:
                redis_data = {"comment_have_pust_num": card_info['have_pust_num'],
                              "comment_need_pust_num": card_info['need_pust_num']}
                redis_client.hset(key, str_today, json.dumps(redis_data))

            logging.info("get action:comment,card_id:%s,redis_data:%s" % (card_info['card_id'], redis_data))

            rpc_invoker = get_rpc_invoker()

            try:
                status = rpc_invoker['qa/irrigation/create_answer_reply'](user_id=card_info['current_user_id'],
                                                                          answer_id=card_info['card_id'],
                                                                          content=card_info[
                                                                              'comment_content']).unwrap()
                logging.info("get_card_info:%s,have_answer_reply:%s" % (card_info, status))
                error = status.get('error', 1)
                if error == 0:
                    return True
                else:
                    send_email_tome(str(card_info) + str(status))
                    return False
            except:
                logging.error("catch exception,err_msg:%s" % traceback.format_exc())
                return False

    except:
        logging_exception()
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return False
