from libs.rpc import get_rpc_invoker
import traceback
from libs.error import logging_exception
import logging
from libs.cache import redis_client
import json
from moment.views.send_email import send_email_tome
import datetime


def follow(card_info):
    try:
        today = datetime.datetime.now()
        str_today = str(today.year) + str(today.month) + str(today.day)
        key = "auto_vest_one_user_action_answer:" + str(card_info['card_id'])
        redis_data = redis_client.hget(key, str_today)
        if redis_data:
            redis_data = json.loads(str(redis_data, encoding="utf8"))
            click_num = int(redis_data.get("follow")) + 1
            redis_data['follow'] = click_num
            redis_client.hset(key, str_today, json.dumps(redis_data))
        else:
            redis_client.delete(key)
            redis_data = {"click": 0, "follow": 1, "comment": 0}
            redis_client.hset(key, str_today, json.dumps(redis_data))

        logging.info("get action:follow,card_id:%s,redis_data:%s" % (card_info['card_id'], redis_data))
        follow_num = redis_data["follow"]

        if follow_num > 10:
            return True
            # send_email_tome(str(redis_data) + str(card_info))
        else:
            print("goodgoodgood")

            # rpc_invoker = get_rpc_invoker()
            # rpc_invoker['api/irrigation/user_add_follow'](follow_user_id=card_info['current_user_id'],
            #                                               followed_user_id=card_info['card_user_id']).unwrap()

        return True
    except:
        logging_exception()
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return False
