#!/usr/bin/env python
# -*- coding: utf-8 -*-
import json
from kafka import KafkaProducer
from kafka import KafkaConsumer
from gm_rpcd.all import bind
import traceback
from django.conf import settings
from follow.views.auto_follow import auto_follow_user
from click.views.auto_click import auto_click_user
from comment.views.auto_comment import auto_comment_user
from moment.views.process_time import save_data_to_kafka
import datetime
import time
import logging
from libs.error import logging_exception
from click.views.click_fun import click
from comment.views.comment_fun import comment
from follow.views.follow_fun import follow
from libs.cache import redis_client
from kafka.structs import TopicPartition
from moment.views.process_time import judge_offset_partition_have_consum


def kafka_consum(topic_name=None):
    topic_name = settings.KAFKA_TOPIC_NAME if not topic_name else topic_name
    consumser_obj = KafkaConsumer(topic_name, bootstrap_servers=settings.KAFKA_BROKER_LIST, enable_auto_commit=True,
                                  auto_commit_interval_ms=1, group_id="vest", auto_offset_reset='earliest')
    consumser_obj.subscribe([topic_name, ])
    try:
        redis_topic_partition_name = "vest:topic_name:" + str(topic_name)
        # topic_partition_info = redis_client.hgetall(redis_topic_partition_name)
        # for partition_id in topic_partition_info:
        #     print (int(partition_id.decode()),topic_name)
        #     consumser_obj.seek(partition=TopicPartition(topic_name,int(partition_id.decode())),offset=int(topic_partition_info[partition_id]))
        while True:
            begin = time.time()
            msg_dict = consumser_obj.poll(timeout_ms=100, max_records=50)
            for msg_value in msg_dict.values():
                for msg in msg_value:
                    card_info = json.loads(str(msg.value, encoding="utf8"))
                    if card_info['card_type'] == "auto_vest":
                        ###在这里去判断一下当前的partition和offset是否已经消费过了  如果已经消费了需要直接去掉数据
                        bol_consum = judge_offset_partition_have_consum(offset=msg.offset, partition=msg.partition)
                        if bol_consum:
                            logging.info("消费到新数据了[%s,%s,%s,%s],get card_info:%s" % (
                                str(msg.topic), str(msg.partition), str(msg.offset), str(msg.key), card_info))
                            redis_client.hset(redis_topic_partition_name, msg.partition, msg.offset)
                            # 如果没有代表是之前的老的数据
                            if 'card_status' not in card_info:
                                card_info['card_status'] = 'answer'

                            current_push_time = card_info['current_push_time']
                            create_time = card_info['create_time']
                            nowtime = datetime.datetime.now()
                            push_time_date = datetime.datetime.strptime(current_push_time, '%Y-%m-%d %H:%M:%S')
                            if push_time_date <= nowtime:  # push_time已经到时间了 需要去下发
                                # 判断如果当前的push_time 和当前的创建时间一样  需要给push_time下发真的push时间
                                if current_push_time == create_time:
                                    if card_info['action_type'] == "comment":
                                        auto_comment_user(card_info, after_day=True)
                                        logging.info("当前卡片ID:%s,auto_comment_user子函数消费处理耗时:%f" % (
                                            card_info['card_id'], time.time() - begin))
                                    elif card_info['action_type'] == "click":
                                        auto_click_user(card_info, after_day=True)
                                        logging.info("当前卡片ID:%s,auto_click_user子函数消费处理耗时:%f" % (
                                            card_info['card_id'], time.time() - begin))

                                    elif card_info['action_type'] == "follow":
                                        auto_follow_user(card_info, after_day=True)
                                        logging.info("当前卡片ID:%s,auto_follow_user子函数消费处理耗时:%f" % (
                                            card_info['card_id'], time.time() - begin))

                                    else:
                                        pass

                                else:
                                    # 当前已下发完 需要判断最新一次的下发时间是否是今天 是的话直接保存起来,l=轮询等待明天再下发
                                    if card_info['have_pust_num'] == card_info['need_pust_num']:
                                        if nowtime.day - push_time_date.day == 0:  # 今日的已经下发完了，需要去取之后的
                                            action_type = card_info['action_type']
                                            logging.info("今天已经下发完了[%s,%s,%s,%s]" % (
                                                str(msg.topic), str(msg.partition), str(msg.offset), str(msg.key)))
                                            if action_type == "comment":
                                                auto_comment_user(card_info, after_day=True)
                                                logging.info("当前卡片ID:%s,auto_comment_user子函数消费处理耗时:%f" % (
                                                    card_info['card_id'], time.time() - begin))
                                            elif action_type == "click":
                                                auto_click_user(card_info, after_day=True)
                                                logging.info("当前卡片ID:%s,auto_comment_user子函数消费处理耗时:%f" % (
                                                    card_info['card_id'], time.time() - begin))
                                            elif action_type == "follow":
                                                auto_follow_user(card_info, after_day=True)
                                                logging.info("当前卡片ID:%s,auto_comment_user子函数消费处理耗时:%f" % (
                                                    card_info['card_id'], time.time() - begin))
                                            else:
                                                pass

                                    else:  # 还有一种是下发时间已到
                                        action_type = card_info['action_type']

                                        if card_info['have_pust_num'] < card_info['need_pust_num'] and \
                                                push_time_date < nowtime:

                                            if action_type == "comment":  # 在这里去调评论的接口
                                                if 'have_comment_number' in card_info and \
                                                        card_info['have_comment_number'] < 20:
                                                    card_info["have_comment_number"] += 1
                                                    logging.info("当前卡片ID:%s,comment1子函数消费处理耗时:%f" % (
                                                        card_info['card_id'], time.time() - begin))
                                                    is_success = comment(card_info)
                                                    logging.info("comment [%s,%s,%s,%s],当前ID:%s，下发状状态:%s" % (
                                                        str(msg.topic), str(msg.partition), str(msg.offset),
                                                        str(msg.key),
                                                        card_info["card_id"], is_success))
                                                    logging.info("当前卡片ID:%s,comment2子函数消费处理耗时:%f" % (
                                                        card_info['card_id'], time.time() - begin))
                                                # 调完接口后需要再次去拿新的push_time的时间
                                                auto_comment_user(card_info)

                                            elif action_type == "click":  # 在这里去调点赞的接口
                                                if 'have_click_number' in card_info and \
                                                        card_info['have_click_number'] < 20:
                                                    card_info["have_click_number"] += 1
                                                    logging.info("当前卡片ID:%s,click1子函数消费处理耗时:%f" % (
                                                        card_info["card_id"], time.time() - begin))
                                                    is_success = click(card_info)
                                                    logging.info("click [%s,%s,%s,%s],当前ID:%s，下发状状态:%s" % (
                                                        str(msg.topic), str(msg.partition), str(msg.offset),
                                                        str(msg.key),
                                                        card_info["card_id"], is_success))
                                                    logging.info("当前卡片ID:%s,click2子函数消费处理耗时:%f" % (
                                                        card_info["card_id"], time.time() - begin))
                                                auto_click_user(card_info)

                                            elif action_type == "follow":  # 在这里去调关注的接口

                                                if 'have_follow_number' in card_info and \
                                                        card_info['have_follow_number'] < 20:
                                                    card_info["have_follow_number"] += 1
                                                    logging.info("当前卡片ID:%s,follow1子函数消费处理耗时:%f" % (
                                                        card_info["card_id"], time.time() - begin))
                                                    is_success = follow(card_info)
                                                    logging.info("当前卡片ID:%s,follow2子函数消费处理耗时:%f" % (
                                                        card_info["card_id"], time.time() - begin))

                                                    logging.info("follow [%s,%s,%s,%s],当前ID:%s，下发状状态:%s" % (
                                                        str(msg.topic), str(msg.partition), str(msg.offset),
                                                        str(msg.key),
                                                        card_info["card_id"], is_success))

                                                auto_follow_user(card_info)

                            else:  # push_time时间未到 需要等待
                                logging.info("follow [%s,%s,%s,%s],push_time未到,需要等待" % (
                                    str(msg.topic), str(msg.partition), str(msg.offset), str(msg.key)))
                                save_data_to_kafka(card_info)
                                pass
            logging.info("消费处理耗时:%f" % (time.time() - begin))
    except:
        consumser_obj.close()
        logging_exception()
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
