from libs.rpc import get_rpc_invoker
import traceback
from libs.error import logging_exception
import logging
from libs.cache import redis_client
import json
from moment.views.send_email import send_email_tome


def comment(card_info):
    try:
        rpc_invoker = get_rpc_invoker()
        rpc_invoker['qa/irrigation/create_answer_reply'](user_id=card_info['current_user_id'],
                                                         answer_id=card_info['card_id'],
                                                         content=card_info['comment_content']).unwrap()
        ####
        key = "auto_vest_one_user_action:" + str(card_info['card_id'])
        redis_data = redis_client.get(key)
        if redis_data:
            redis_data = json.loads(redis_data)
            click_num = int(redis_data.get("comment")) + 1
            redis_data['comment'] = click_num
            redis_client.set(key, json.dumps(redis_data))
        else:
            redis_data = {"click": 0, "follow": 0, "comment": 1}
            redis_client.set(key, json.dumps(redis_data))
        redis_client.expire(key, time=24 * 60 * 60)

        logging.info("get redis_data:%s" % redis_data)

        values = list(redis_data.values())
        s = [True for i in values if i > 0]
        if len(s) > 0:
            send_email_tome(str(redis_data) + str(card_info))

        return True
    except:
        logging_exception()
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return False
