--***************************************************************
--*脚本名称: create_test_20190713.sql
--*功能: 创建(test)的映射表
--*业务名称: tl
--*输入数据: hdfs://bj-gmei-hdfs/data/log/thirdparty/test_20190713/partition_date=${partition_date}/
--*作者: data-exchange
--*更新时间: 2019-07-12 19:40:08
--***************************************************************


--设置全局变量&UDF
SET mapreduce.job.queuename=data;

--声明数据库
USE default;

--创建HDFS映射表
CREATE EXTERNAL TABLE IF NOT EXISTS test_20190713 (
  answer_id BIGINT COMMENT '1'
  ,create_time STRING COMMENT '创建时间'
  ,id BIGINT COMMENT 'ID'
  ,image_url STRING COMMENT '图片地址'
  ,update_time STRING COMMENT '1'
) COMMENT 'test'
PARTITIONED BY (partition_date STRING COMMENT '分区日期')
ROW FORMAT
    DELIMITED FIELDS TERMINATED BY '\001'
    COLLECTION ITEMS TERMINATED BY '\002'
    MAP KEYS TERMINATED BY '\003'
    LINES TERMINATED BY '\n'
    NULL DEFINED AS ''
STORED AS TEXTFILE
LOCATION '/data/log/thirdparty/test_20190713';