--***************************************************************
--*脚本名称: create_test_20190716.sql
--*功能: 创建api_alipayaccout(test)的映射表
--*业务名称: tl
--*输入数据: hdfs://bj-gmei-hdfs/data/log/thirdparty/test_20190716/partition_date=${partition_date}/
--*作者: data-exchange
--*更新时间: 2019-07-12 20:25:06
--***************************************************************


--设置全局变量&UDF
SET mapreduce.job.queuename=data;

--声明数据库
USE default;

--创建HDFS映射表
CREATE EXTERNAL TABLE IF NOT EXISTS test_20190716 (
  account STRING COMMENT '{"chs_name":"支付宝账户","description":"","etl":"","value":"","remark":""}',
  created_time STRING COMMENT '{"chs_name":"创建时间","description":"","etl":"","value":"","remark":""}',
  id BIGINT COMMENT '{"chs_name":"ID","description":"","etl":"","value":"","remark":""}',
  name STRING COMMENT '{"chs_name":"用户名","description":"","etl":"","value":"","remark":""}',
 updated_time STRING COMMENT '{"chs_name":"最后更新时间","description":"","etl":"","value":"","remark":""}',
) COMMENT 'test'
PARTITIONED BY (partition_date STRING COMMENT '分区日期')
ROW FORMAT
    DELIMITED FIELDS TERMINATED BY '\001'
    COLLECTION ITEMS TERMINATED BY '\002'
    MAP KEYS TERMINATED BY '\003'
    LINES TERMINATED BY '\n'
    NULL DEFINED AS ''
STORED AS TEXTFILE
LOCATION '/data/log/thirdparty/test_20190716';