# -*- coding:utf-8 -*-
import time
import pprint
import json

from aliyunsdkcore import client
from aliyunsdkcms.request.v20170301 import QueryMetricListRequest, QueryMetricLastRequest

import settings

class ALiYun(object):
    def __init__(self):
        self.key_id = settings.ALIYUN_KEY
        self.key_secret = settings.ALIYUN_KEY_SECRET

    def get_client(self, region):
        clt = client.AcsClient(self.key_id, self.key_secret, region)
        return clt

    def json_format(self, response):
        if isinstance(response, bytes):
            response = response.decode()
        return json.loads(response)


class CMS(ALiYun):
    def get_rds_metric(self, rds_instance_id, metric, duration=60*3):
        """
        获取实例ID为rds_instance_id的metric监控项
        :param duration: 过去多少时间内的metrics, 单位s
        """
        client = self.get_client('cn-qingdao')
        request = QueryMetricListRequest.QueryMetricListRequest()
        request.set_accept_format('json')
        request.set_Project('acs_rds_dashboard')
        request.set_Metric(metric)
        end_timestamp = int(time.time()) * 1000
        start_timestamp = end_timestamp - duration*1000
        request.set_StartTime(start_timestamp)
        request.set_EndTime(end_timestamp)
        dimensions = {
            'instanceId': rds_instance_id
        }
        request.set_Dimensions(json.dumps(dimensions))
        # request.set_Period('60')
        result = client.do_action_with_exception(request)
        # pprint.pprint(self.json_format(result))
        return self.json_format(result)


def main():
    aliyun_cms = CMS()
    rds_instance_list = settings.RDS_INSTANCES
    for rds_instance in rds_instance_list.keys():
        aliyun_cms.get_rds_metric(rds_instance, 'CpuUsage')
        aliyun_cms.get_rds_metric(rds_instance, 'DiskUsage')

if __name__ == '__main__':
    main()
