# -*- coding:utf-8 -*-
import time
import json
import random

from prometheus_client import start_http_server
from prometheus_client.core import GaugeMetricFamily, REGISTRY

import settings
from aliyun import CMS

class RDSCollector(object):
    def collect(self):
        aliyun_cms = CMS()
        # instances = ['rds-0', 'rds-1', 'rds-2']
        rds_instances = settings.RDS_INSTANCES
        metrics = []
        for rds_id, rds_name in rds_instances.items():
            cpu_usage_metric = GaugeMetricFamily('rds_cpu_usage', 'cpu usage of this rds instance', labels=['rds_name'])
            disk_usage_metric = GaugeMetricFamily('rds_disk_usage', 'disk usage of this rds instance', labels=['rds_name'])
            iops_usage_metric = GaugeMetricFamily('rds_iops_usage', 'iops usage', labels=['rds_name'])
            connection_usage_metric = GaugeMetricFamily('rds_connection_usage', 'connection usage', labels=['rds_name'])
            # 'data_delay': ,
            memory_usage_metric = GaugeMetricFamily('rds_memory_usage', 'memory usage', labels=['rds_name'])
            # 'mysql_network_in': ,
            # 'mysql_network_out': ,
            cpu_datapoints = aliyun_cms.get_rds_metric(rds_id, 'CpuUsage')['Datapoints']
            # disk_datapoints = aliyun_cms.get_rds_metric(rds_id, 'DiskUsage')['Datapoints']
            # iops_datapoints = aliyun_cms.get_rds_metric(rds_id, 'IOPSUsage')['Datapoints']
            # connection_datapoints = aliyun_cms.get_rds_metric(rds_id, 'ConnectionUsage')['Datapoints']
            memory_datapoints = aliyun_cms.get_rds_metric(rds_id, 'MemoryUsage')['Datapoints']
            
            # datapoints按时间升序排列
            for p in cpu_datapoints:
                cpu_usage_metric.add_metric([rds_name], p['Average'], p['timestamp']/1000)
            
            # for p in disk_datapoints:
            #     disk_usage_metric.add_metric([rds_name], p['Average'], p['timestamp']/1000)

            # for p in iops_datapoints:
            #     iops_usage_metric.add_metric([rds_name], p['Average'], p['timestamp']/1000)

            # for p in connection_datapoints:
            #     connection_usage_metric.add_metric([rds_name], p['Average'], p['timestamp']/1000)

            for p in memory_datapoints:
                memory_usage_metric.add_metric([rds_name], p['Average'], p['timestamp']/1000)

            # # 一次抓的多个时间升序排列的metric可同时被prometheus收集到
            # current_time = time.time()
            # for i in range(16, 0, -1):
            #     cpu_usage_metric.add_metric([rds_name], random.random(), current_time-i)
            #     disk_usage_metric.add_metric([rds_name], random.random(), current_time-i)

            metrics.extend([
                cpu_usage_metric, disk_usage_metric, iops_usage_metric, connection_usage_metric,
                memory_usage_metric,
            ])

        for m in metrics:
            yield m

def main():
    REGISTRY.register(RDSCollector())
    start_http_server(7086)
    while True:
        time.sleep(1)

if __name__ == '__main__':
    main()