# -*- coding:utf-8 -*-
import time
import json
import random
import math

from prometheus_client import start_http_server
from prometheus_client.core import GaugeMetricFamily, REGISTRY

import settings
from aliyun import CMS

aliyun_cms = CMS()
rds_instances = settings.RDS_INSTANCES

class RDSCollector(object):
    def collect(self):
        metrics = []
        # 阿里云SDK查询字段与prometheus metric name的映射
        queryname_metricname = {
            'CpuUsage': 'rds_cpu_usage_ratio',
            'DiskUsage': 'rds_disk_usage_ratio',
        }
        metrics_from_aliyun = {}
        all_rds_id = rds_instances.keys()

        # get metrics from aliyun
        for label in queryname_metricname.keys():
            metrics_from_aliyun[label] = []

            for i in range(0, int(math.ceil(len(all_rds_id)/10.0))):
                instance_id_list = all_rds_id[10*i : 10*(i+1)]
                try:
                    res = aliyun_cms.get_rds_metric(instance_id_list, label)
                    metrics_from_aliyun[label].extend(res['Datapoints'])
                except Exception as e:
                    print(e)

        # transform to prometheus metric format
        for queryname, datapoints in metrics_from_aliyun.items():
            metricname = queryname_metricname[queryname]
            avg_metric_family = GaugeMetricFamily(metricname, metricname, labels=['rds_name'])
            max_metricname = '{}_max'.format(metricname)
            max_metric_family = GaugeMetricFamily(max_metricname, max_metricname, labels=['rds_name'])

            for point in datapoints:
                rds_name = rds_instances[point['instanceId']]
                avg_metric_family.add_metric([rds_name], point['Average']/100, point['timestamp']/1000)
                max_metric_family.add_metric([rds_name], point['Maximum']/100, point['timestamp']/1000)
            
            metrics.append(avg_metric_family)

        for m in metrics:
            yield m

def main():
    REGISTRY.register(RDSCollector())
    start_http_server(7086)
    while True:
        time.sleep(1)

if __name__ == '__main__':
    main()