############################ aliyun configuration ############################################
# 要监控的数据库实例
aliyun_instances:
  instance_id:
    name: instance_name
    # 连接数利用率因子，连接数利用率*该因子得到一个较为统一的标准，默认1
    connection_usage_factor: 1
    # iops利用率因子, 默认 1
    iops_usage_factor: 1
    # cpu利用率因子
    cpu_usage_factor: 1
    # 内存利用率因子
    memory_usage_factor: 1
    # 数据库类型，主库(master) or 从库(slave), 默认master
    type: master

  instance_id2:
    name: instance_name2

# 要监控的数据库指标
aliyun_metrics:
  # 阿里云SDK查询字段
  CpuUsage:
    # prometheus metric name
    name: rds_cpu_usage_ratio
    # CPU利用率因子，CPU利用率*该因子得到一个较为统一的标准
    factor: cpu_usage_factor

  MemoryUsage:
    name: rds_memory_usage_ratio
    factor: memory_usage_factor

  ConnectionUsage:
    name: rds_connection_usage_ratio
    factor: connection_usage_factor

  IOPSUsage:
    name: rds_iops_usage_ratio
    factor: iops_usage_factor

# aliyun key and secret
aliyun_settings:
  key: xxx
  secret: xxx

############################ aliyun configuration ############################################


############################ tencent configuration ############################################
# 要监控的数据库实例
tencent_instances:
  instance_id:
    name: instance_name
    # 连接数利用率因子，连接数利用率*该因子得到一个较为统一的标准，默认1
    connection_usage_factor: 1
    # iops利用率因子, 默认 1
    iops_usage_factor: 1
    # cpu利用率因子
    cpu_usage_factor: 1
    # 内存利用率因子
    memory_usage_factor: 1
    # 数据库类型，主库(master)or从库(slave), 默认master
    type: master

  instance_id2:
    name: instance_name2

# 要监控的数据库指标
tencent_metrics:
  # 阿里云SDK查询字段
  CPUUseRate:
    # prometheus metric name
    name: rds_cpu_usage_ratio
    # CPU利用率因子，CPU利用率*该因子得到一个较为统一的标准
    factor: cpu_usage_factor

  MemoryUse:
    name: rds_memory_usage_ratio
    factor: memory_usage_factor

  ThreadsConnected:
    name: rds_connection_usage_ratio
    factor: connection_usage_factor

  # IOPSUsage:
  #   name: rds_iops_usage_ratio
  #   factor: iops_usage_factor

# tencent key and secret
tencent_settings:
  secret_id: xxx
  secret_key: xxx
  data_interval: 60
############################ tencent configuration ############################################