# -*- coding:utf-8 -*-
import time
import json
import random
import math

import yaml
from prometheus_client import start_http_server
from prometheus_client.core import REGISTRY

from exporter import TencentExporter, AliyunExporter

class RDSCollector(object):
    def __init__(self):
        self.exporter_list = [
            TencentExporter(),
            # AliyunExporter(),
        ]

    def collect(self):
        metrics = []
        for exporter in self.exporter_list:
            metrics.extend(exporter.export_prometheus_data())
        for m in metrics:
            yield m

def main():
    REGISTRY.register(RDSCollector())
    start_http_server(7086)
    while True:
        time.sleep(1)

if __name__ == '__main__':
    main()
