# -*- coding:utf-8 -*-
import time
import pprint
import json

import yaml
from aliyunsdkcore import client
from aliyunsdkcms.request.v20170301 import QueryMetricListRequest, QueryMetricLastRequest

with open('config.yaml', 'r') as f:
    config = yaml.load(f)

class ALiYun(object):
    def __init__(self):
        self.key_id = config['aliyun_settings']['key']
        self.key_secret = config['aliyun_settings']['secret']

    def get_client(self, region):
        clt = client.AcsClient(self.key_id, self.key_secret, region)
        return clt

    def json_format(self, response):
        if isinstance(response, bytes):
            response = response.decode()
        return json.loads(response)


class CMS(ALiYun):
    def get_rds_metric(self, rds_instance_ids, metric, duration=60*6):
        """
        获取实例ID在rds_instance_id列表中的metric监控项
        https://yq.aliyun.com/ask/426959?spm=a2c4e.11154873.tagmain.6.4c8d671b5KwueI一次最多获取十个实例的监控项
        :param duration: 过去多少时间内的metrics, 单位s
        """
        assert len(rds_instance_ids) <= 10, '一次查询的rds_instace_ids不能超过十个'
        client = self.get_client('cn-qingdao')
        request = QueryMetricListRequest.QueryMetricListRequest()
        request.set_accept_format('json')
        request.set_Project('acs_rds_dashboard')
        request.set_Metric(metric)
        end_timestamp = int(time.time()) * 1000
        start_timestamp = end_timestamp - duration*1000
        request.set_StartTime(start_timestamp)
        request.set_EndTime(end_timestamp)
        dimensions = [{
            'instanceId': rds_instance_id
        }for rds_instance_id in rds_instance_ids]
        request.set_Dimensions(json.dumps(dimensions))
        # request.set_Period('60')
        result = client.do_action_with_exception(request)
        # pprint.pprint(self.json_format(result))
        return self.json_format(result)

