【WIP】Mac下搭建本地k8s，并进行开发、调试和部署

## 环境准备
### 安装Docker/k8s

1. 安装 [Docker for Mac](https://docs.docker.com/docker-for-mac/install/)，Version>=18.06，低版本可能不自带Kubernetes

2. 设置 `Docker` 中国官方镜像加速 [registry mirror](https://www.docker-cn.com/registry-mirror) ```https://registry.docker-cn.com```
![mirror](./image/mirror.jpg)

3. 预先从阿里云`Docker`镜像下载 `Kubernetes` 所需要的镜像, 可以通过修改 [./images](./images) 文件定制你自己需要的镜像
```bash
$ ./load_images.sh
```

4. 在`Docker for Mac` 设置中启用 `Kubernetes` 选项, 并等待一会儿，直到 `Kubernetes` 开始运行。
![k8s](./image/2018-11-01-11-46-06.png)

5. 切换`Kubernetes`运行上下文至 `docker-for-desktop`
```bash
# 一般只有在之前用其他方式运行过Kubernetes才需要
$ kubectl config use-context docker-for-desktop
```

6. 验证 `Kubernetes` 集群状态
```bash
$ kubectl cluster-info
$ kubectl get nodes
```

7. 部署 `Kubernetes dashboard`
```bash
$ kubectl apply -f https://raw.githubusercontent.com/kubernetes/dashboard/master/src/deploy/recommended/kubernetes-dashboard.yaml
# 开启本机访问代理
$ kubectl proxy
```

通过下面的连接访问 `Dashboard`:
[`http://localhost:8001/api/v1/namespaces/kube-system/services/https:kubernetes-dashboard:/proxy/`](
http://localhost:8001/api/v1/namespaces/kube-system/services/https:kubernetes-dashboard:/proxy/)
访问时出现下面界面可跳过：
![](./image/2018-11-01-11-36-20.png)

（可选）获取 `Dashboard` `admin` 权限:
[`https://github.com/kubernetes/dashboard/wiki/Access-control#admin-privileges`](https://github.com/kubernetes/dashboard/wiki/Access-control#admin-privileges)


### 安装Helm
```
# 用当前目录下的可执行文件，版本2.10.0
$ cp helm /usr/local/bin/helm

# 初始化本地 CLI 并 将 Tiller 安装到 Kubernetes cluster
$ mkdir -p ~/.helm/repository
$ touch ~/.helm/repository/repositories.yaml
$ helm init
$ helm repo add stable https://aliacs-app-catalog.oss-cn-hangzhou.aliyuncs.com/charts/
$ helm repo add incubator https://aliacs-app-catalog.oss-cn-hangzhou.aliyuncs.com/charts-incubator/
```


### 一些初始化配置
1. 添加证书：
```
sudo security add-trusted-cert -d -r trustRoot -k /Library/Keychains/System.keychain ./harbor.crt
```
**重启docker**

2. `docker login`
```
docker login harbor.test.gengmei
username: gmuser
password: Gengmei123!
```

3. `docker-for-mac`上添加`File Sharing`配置 `/srv/apps`、`/data/log`，添加后点击`Apply & Restart`
![](./image/2018-11-01-11-57-39.png)

若出现如下报错，可先不必添加，但是可能会出现日志挂载不到本地Mac的情况，可能后面需要手动更改日志目录（待验证）。
![](./image/2018-10-25-13-30-29.png)

**至此本地k8s基础环境搭建完成，可以使用gm-cli构建本地服务集群了，具体使用参考 [gm-cli](http://git.igengmei.com/system/gm-cli)**


