# coding=utf-8
from doris.base import *
from .log_settings import *
from celery import *

from celery.schedules import crontab
import pyssdb


CELERY_BROKER_URL =  'redis://192.168.168.142/0'
REDIS_URL = 'redis://192.168.168.142/1'


ES_V2_HOSTS = [
    {'host': '192.168.168.142', 'port': 9200},
]
ES_INDEX_PREFIX = 'gm_test'


COUNT_LIMIT = 50
REDIS = {
    'doctor': {'host': '192.168.168.142', 'port': 6379, 'db': 1,},
}


RAVEN_CONFIG = {
    'dsn': 'http://29e77782db3c4429857cb1b6d69d9463:d55eafe28ae64f6e8c4a82fa3bc50fdd@sentry.gengmei.cc/80',
}


CELERYBEAT_SCHEDULE = {
    'doris_ trans2es': {
        'task': 'rank.tasks.doctor_statdata_2_cache',
        # 'schedule': timedelta(seconds=1),
        'schedule': crontab(hour=2, minute=0),
    },
    'doris_cal_device_interest': {
        'task': 'recommend.tasks.cal_userinterest_rank',
        # 'schedule': timedelta(seconds=1),
        'schedule': crontab(hour=2, minute=0),
    },
    'doris_cal_servicehot_rank': {
        'task': 'recommend.tasks.cal_servicehot_rank',
        # 'schedule': timedelta(seconds=1),
        'schedule': crontab(hour=2, minute=0),
    }
}



SSDB_CLIENT = pyssdb.Client(host='192.168.168.143', port=8888)
