# coding=utf8
"""
Django settings for flag_ship project.

For more information on this file, see
https://docs.djangoproject.com/en/1.7/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/1.7/ref/settings/
"""

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
import os
import helios
import helios.rpc

BASE_DIR = os.path.dirname(os.path.dirname(__file__))

# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/1.7/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = 'zng=%a*!bokrd#=%%rawhyp0)1qr15i#x7m@hetqd%z_+kv599'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

TEMPLATE_DEBUG = DEBUG

ALLOWED_HOSTS = ['*']

# Application definition
INSTALLED_APPS = (
    'django.contrib.contenttypes',
    'django.contrib.staticfiles',

    'django_jinja',

    'helios',
    'viewbase',

    'app',
)

MIDDLEWARE_CLASSES = (
    'django.contrib.sessions.middleware.SessionMiddleware',
)

SESSION_ENGINE = 'django.contrib.sessions.backends.cache'

ROOT_URLCONF = 'flag_ship.urls'

WSGI_APPLICATION = 'flag_ship.wsgi.application'

# Database
# https://docs.djangoproject.com/en/1.7/ref/settings/#databases

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': ':memory:',
    }
}

# Internationalization
# https://docs.djangoproject.com/en/1.7/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'Asia/Shanghai'

USE_I18N = True

USE_L10N = True

USE_TZ = True

# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/1.7/howto/static-files/

STATIC_URL = '/static/'

STATICFILES_DIRS = (
    ('', os.path.join(BASE_DIR, '..', 'frontend', 'static')),
)

STATICFILES_FINDERS = (
    'django.contrib.staticfiles.finders.FileSystemFinder',
    'django.contrib.staticfiles.finders.AppDirectoriesFinder',
)

TEMPLATE_LOADERS = (
    'django_jinja.loaders.FileSystemLoader',
    'django_jinja.loaders.AppLoader',
)

TEMPLATE_DIRS = (
    os.path.join(BASE_DIR, '..', 'frontend', 'templates'),
)

DEFAULT_JINJA2_TEMPLATE_EXTENSION = ''

RPC_URL = 'http://rpc.test.gengmei.cc/api/'
# RPC_URL = 'http://127.0.0.1:8001/api/'
RPC_SECRET = ''
RPC_INVOKER = helios.rpc.create_default_invoker(debug=DEBUG)
APP_CONFIG = {
    'url_base': 'http://localhost:8000',
    'app_download_page': '/app/download',
    'mobile_index_page': 'http://m.gengmei.cc/',
    'qiniu_host': 'http://pic.gengmei.cc/',
    'default_paging_size': 20,
}

# 顶部导航Tabs
TAB_INDEX = '/'
TAB_TAGS = '/diary_list'
TAB_PROMOTION = '/promotion_list'
TAB_WIKI = '/wiki_list'
TAB_EXPERT = '/expert_list'
TAB_POST = '/post_list'
TAB_HOSPITAL = '/hospital_list'

TABS = [{'name': u'首页', 'url': TAB_INDEX},
        {'name': u'项目', 'url': TAB_TAGS},
        {'name': u'美购', 'url': TAB_PROMOTION},
        {'name': u'百科', 'url': TAB_WIKI},
        {'name': u'专家', 'url': TAB_EXPERT},
        {'name': u'医院', 'url': TAB_HOSPITAL},
        {'name': u'健康资讯', 'url': TAB_POST},
        ]

# 首页默认显示的Tag
FRONT_DEFAULT_TAGS = [{'id': 1, 'color': '#ffd34e', 'position': 1, 'icon': 'http://pic.gengmei.cc/2014/12/24/b3076876ff'},
                      {'id': 2, 'color': '#ffae5e', 'position': 2, 'icon': 'http://pic.gengmei.cc/2014/12/24/2624935b91'},
                      {'id': 3, 'color': '#ff6c8f', 'position': 4, 'icon': 'http://pic.gengmei.cc/2014/12/24/e7f379e88f'},
                      {'id': 7, 'color': '#9290f6', 'position': 5, 'icon': 'http://pic.gengmei.cc/2014/12/24/0ef5dafde4'},
                      {'id': 4, 'color': '#5e9bff', 'position': 6, 'icon': 'http://pic.gengmei.cc/2014/12/24/1eea8df935'},
                      {'id': 5, 'color': '#5dcdfc', 'position': 7, 'icon': 'http://pic.gengmei.cc/2014/12/24/85df448756'}]
# 医生默认头像
DEFAULT_EXPERT_PORTRAIT = 'http://pic.gengmei.cc/2015/03/13/fbde86be25-web'

# TDK
TDK = {
    'title': u'更美APP官网—整形整容微整形社区与特卖平台',
    'keywords': u'更美，更美APP，更美APP官网，更美网，整形，整容，微整形',
    'description': u'更美APP如今是中国最大的医学美容与消费医疗服务平台，提供生活消费类医疗服务，品类包括整形、齿科、眼科、抗衰老、营养、心理（计划中）等。'
}

# Redis配置
CACHES = {
    "default": {
        "BACKEND": "django_redis.cache.RedisCache",
        "LOCATION": "redis://192.168.168.142/1",
        "OPTIONS": {
            "CLIENT_CLASS": "django_redis.client.DefaultClient",
        }
    }
}

# 百度阿拉丁KEY
ALADING_KEY = 't7bu89c9ys4ix5u7o6t7v8kuxbtos1qy'
