# -*- coding: UTF-8 -*-
from __future__ import unicode_literals

from middleware.gm_logging import RequestInfoExtractor

"""
Django settings for hera project.

Generated by 'django-admin startproject' using Django 1.8.1.

For more information on this file, see
https://docs.djangoproject.com/en/1.8/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/1.8/ref/settings/
"""

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
import os
from gm_types.gaia import GADGET_TEMPLATE_TYPE
from .logger import LOGGING, APP_LOG_DIR
from gm_account import GM_ACCOUNT_DIR
from .perm_settings import *

BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))

# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/1.8/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = 'ke12r0&e(-8!^yznske#y0&i!akitm9$5s-jfemw%-0bp&q&(5'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

ALLOWED_HOSTS = ['.gengmei.cc', '127.0.0.1', '.gmei.com', '.igengmei.com', 'localhost']

IMAGE_HERA_DOMAIN = 'http://hera.s.igengmei.com'

# Application definition

INSTALLED_APPS = (
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',

    'raven.contrib.django.raven_compat',
    'django_extensions',

    'big',
    'backend.accounts',
    'backend.order',
    'backend.diary',
    'backend.tag',
    'backend.service',
    'backend.coupon',
    'backend.special',
    'backend.comparation',
    'backend.tasks',
    'backend.channelbuild',
)

MIDDLEWARE_CLASSES = (
    'middleware.profile.ProfileMiddleware',

    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.auth.middleware.SessionAuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
    'django.middleware.security.SecurityMiddleware',
    'raven.contrib.django.middleware.SentryLogMiddleware',

    'gm_logging.django.middleware.LoggingMiddleware',  # gm-logging add by lipeng hera1.11
    'middleware.rpc.RPCSetupMiddleware',
    'middleware.rpc.RPCSystemExceptionDebugMiddleware',
    # 'middleware.login_required.LoginRequiredMiddleware',
    'gm_account.middleware.login_required.LoginRequiredMiddleware',
    # 'backend.accounts.middlewares.loginuser.LoginUserMiddleware',
)

ROOT_URLCONF = 'hera.urls'

TEMPLATE_DIRS = (
    os.path.join(BASE_DIR, 'templates'),
    os.path.join(GM_ACCOUNT_DIR, 'templates'),
)

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.jinja2.Jinja2',
        'DIRS': [
            os.path.join(BASE_DIR, 'templates'),
        ],
        'APP_DIRS': True,
        'OPTIONS': {
            'environment': 'utils.jinja2.environment',
        },
    },
    {
        "BACKEND": "django.template.backends.django.DjangoTemplates",
        "DIRS": TEMPLATE_DIRS,
        "APP_DIRS": True,
        "OPTIONS": {
            "context_processors": [
                "django.contrib.auth.context_processors.auth",
                "django.template.context_processors.debug",
                "django.template.context_processors.i18n",
                "django.template.context_processors.media",
                "django.template.context_processors.static",
                "django.template.context_processors.tz",
                "django.contrib.messages.context_processors.messages",
            ],
        },
    },
]

WSGI_APPLICATION = 'hera.wsgi.application'

LANGUAGE_CODE = 'zh-hans'

TIME_ZONE = 'Asia/Shanghai'

USE_I18N = True

USE_L10N = True

# USE_TZ = True # use local time


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/1.8/howto/static-files/

STATIC_URL = '/static/'
STATIC_ROOT = os.path.join(BASE_DIR, 'website', 'static')

STATICFILES_DIRS = (
    os.path.join(BASE_DIR, 'static'),
)

MEDIA_URL = '/media/'
MEDIA_ROOT = os.path.join(BASE_DIR, 'website', 'media')

SECURE_PROXY_SSL_HEADER = ('HTTP_X_FORWARDED_PROTO', 'https')

RPC_URL = 'http://rpc.test.gengmei.cc/api/'
RPC_KEY = "basic:c3AUKzE4iaGc5SBtkm3zMbjepw+vn7VHr/5fXaupEAo/HBeeVk6w+4EWEubwF1K9j6KSckd17hpBpQkNr9+uoA=="

USER_COOKIE_NAME = 'session_key'
USER_COOKIE_TIME = 864000  # 10 days

LOGIN_URL = '/account/login/'
CHANNELBUILD_URL = '/channelbuild/version_create/'

# doctor backend domain
DOCTOR_URL = 'http://doctor.igengmei.com'

SIMPLE_PAGE = False  # False 为上下页

LIST_INFORMATION = True  # 是否显示列表数量信息

GADGET_LAYOUT_MAP = {
    GADGET_TEMPLATE_TYPE.SINGLE: {
        'image_info': {
            'a': "750*300",
        },
        'layout_image': IMAGE_HERA_DOMAIN + '/2016/01/21/501bfa3997',
        'image_num': 1,
    },
    GADGET_TEMPLATE_TYPE.DOUBLE: {
        'image_info': {
            'a': "375*300",
            'b': "375*300",
        },
        'layout_image': IMAGE_HERA_DOMAIN + '/2016/01/21/3f9eb0962b',
        'image_num': 2,
    },
    GADGET_TEMPLATE_TYPE.TRIPLE: {
        'image_info': {
            'a': "375*375",
            'b': "375*187",
            'c': "375*187",
        },
        'layout_image': IMAGE_HERA_DOMAIN + '/2016/01/21/8c15fb87c1',
        'image_num': 3,
        'seckill': True,
    },
    GADGET_TEMPLATE_TYPE.FOUR: {
        'image_info': {
            'a': "187*200",
            'b': "187*200",
            'c': "187*200",
            'd': "187*200",
        },
        'layout_image': IMAGE_HERA_DOMAIN + '/2016/01/21/cc4383a0b1',
        'image_num': 4,
    },
    GADGET_TEMPLATE_TYPE.FOUR_POLYMER: {
        'image_info': {
            'a': "188*111",
            'b': "188*111",
            'c': "188*111",
            'd': "188*111",
        },
        'layout_image': IMAGE_HERA_DOMAIN + '/2016/01/21/cc4383a0b1',
        'image_num': 4,
    },
    GADGET_TEMPLATE_TYPE.FIVE: {
        'image_info': {
            'a': "750*200",
            'b': "375*200",
            'c': "375*200",
            'd': "375*200",
            'e': "375*200",
        },
        'layout_image': IMAGE_HERA_DOMAIN + '/2016/01/21/4583f31b6f',
        'image_num': 5,
    },
    GADGET_TEMPLATE_TYPE.SEVEN: {
        'image_info': {
            'a': "375*375",
            'b': "375*187",
            'c': "375*187",
            'd': "187*200",
            'e': "187*200",
            'f': "187*200",
            'g': "187*200",
        },
        'layout_image': IMAGE_HERA_DOMAIN + '/2016/01/21/577bb4f2fb',
        'image_num': 7,
        'seckill': True,
    },
    GADGET_TEMPLATE_TYPE.NINE_1: {
        'image_info': {
            'a': "250*250",
            'b': "250*250",
            'c': "250*250",
            'd': "250*250",
            'e': "250*250",
            'f': "250*250",
            'g': "250*250",
            'h': "250*250",
            'i': "250*250",
        },
        'layout_image': IMAGE_HERA_DOMAIN + '/2016/01/21/5eb45bc936',
        'image_num': 9,
    },
    GADGET_TEMPLATE_TYPE.NINE_2: {
        'image_info': {
            'a': "750*200",
            'b': "187*200",
            'c': "187*200",
            'd': "187*200",
            'e': "187*200",
            'f': "187*200",
            'g': "187*200",
            'h': "250*250",
            'i': "250*250",
        },
        'layout_image': IMAGE_HERA_DOMAIN + '/2016/01/21/d1036c31d9',
        'image_num': 9,
    },
    GADGET_TEMPLATE_TYPE.FOUR_NEW: {
        'image_info': {
            'a': "320*480",
            'b': "429*240",
            'c': "214*239",
            'd': "214*239",
        },
        'layout_image': IMAGE_HERA_DOMAIN + '/2016/05/12/5605410fc6',
        'image_num': 4,
    },
    GADGET_TEMPLATE_TYPE.SIX: {
        'image_info': {
            'a': "374*180",
            'b': "375*180",
            'c': "186*228",
            'd': "187*228",
            'e': "187*228",
            'f': "187*228",
        },
        'layout_image': IMAGE_HERA_DOMAIN + '/2016/05/12/9b7ff0e768',
        'image_num': 6,
    }
}

# 用户组, 回复时选择用户组
REPLY_USER_GROUPS = {
    'user': 'xiaozhens',
    'doctor': 'doctor_reply',
    'secretary': 'secretary_reply'
}

# apk 七牛上传空间
APK_SCOPE = 'download'
APK_DOMAIN = 'http://dl.igengmei.com/'
DEFAULT_CHANNEL = 'benzhan'
APK_RELEASE_DIR = 'test'
APK_BUILD_DIR = 'testbuild'

# 活动关联的默认渠道
CAMPAIGN_CHANNEL_ID = 21
# 专题关联的默认渠道
SPECIAL_CHANNEL_ID = 22


# add by lipeng hera1.11 gm-logging
def GM_LOGGING():
    return {
        'request_info_extractor_class': RequestInfoExtractor,
        'log': {
            'basedir': APP_LOG_DIR,
            'prefix': 'hera',
            'buffered': not DEBUG,
        }
    }


EMAIL_HOST = 'smtp.exmail.qq.com'
EMAIL_PORT = 25
EMAIL_USER = ''
EMAIL_PSWD = ''

EXEMPT_URLS = [
    CHANNELBUILD_URL,
    r'^/searchkeyword/dict$',
    r'^/system/statuses',
]

CATEGORYGADGET = [
    {
        'image_url': IMAGE_HERA_DOMAIN + '/2017/06/28/ad41bf947f',
        'image_info': {
            'A': '240*156',
            'B': '243*77',
            'C': '243*77',
            'D': '243*77',
            'E': '243*77',
            'F': '243*77',
            'G': '243*77',
            'H': '243*77',
        },
        'start_image_num': 0,
    },
    {
        'image_url': IMAGE_HERA_DOMAIN + '/2017/06/28/42e7339054',
        'image_info': {
            'A': '240＊156',
            'B': '243*77',
            'C': '243*77',
            'D': '243*77',
            'E': '243*77',
        },
        'start_image_num': 8,
    },
    {
        'image_url': IMAGE_HERA_DOMAIN + '/2017/06/28/138a86f96b',
        'image_info': {
            'A': '240*77',
            'B': '243*77',
            'C': '243*77',
            'D': '243*77',
            'E': '243*77',
            'F': '243*77',
        },
        'start_image_num': 13,
    },
]

SELF_SUPPORT_WHITELIST_HOSPITAL = [
]

COUPON_DISTRIBUTE_CHANNEL_ID = 41
M_SITE = 'm.igengmei.com'


DATAQUERY_RELATION = {
    ('gaia', 'pointusergoods', 'user_id'): ('gaia', 'user'),
    ('plutus', 'installment', 'order_id'): ('gaia', 'order'),
    ('plutus', 'installment', 'borrower__person_id'): ('gaia', 'person'),
    ('plutus', 'olinsurancehospital', 'doctor_id'): ('gaia', 'doctor'),
    ('plutus', 'olinsurancehospital', 'city'): ('gaia', 'city'),
    ('apollo', 'order', 'order_id'): ('gaia', 'order'),
    ('apollo', 'order', 'salesman__person_id'): ('gaia', 'person'),
    ('apollo', 'salesman', 'person_id'): ('gaia', 'person'),
    ('apollo', 'invitecode', 'owner'): ('gaia', 'person'),
    ('gaia', 'stockalert', 'diary_id'): ('gaia', 'diary'),
    ('mimas', 'question', 'user_id'): ('gaia', 'user'),
    ('mimas', 'answer', 'user_id'): ('gaia', 'user'),
    ('mimas', 'bdanswer', 'user_id'): ('gaia', 'user'),
    ('mimas', 'answerreply', 'user_id'): ('gaia', 'user'),
    ('gaia', 'message', 'user_id'): ('gaia', 'user'),
    ('gaia', 'message', 'to_user_id'): ('gaia', 'user'),
    ('gaia', 'message', 'conversation__user_id'): ('gaia', 'user'),
    ('gaia', 'message', 'conversation__user_status_set__user_id'): ('gaia', 'user'),
    ('gaia', 'conversation', 'user_id'): ('gaia', 'user'),
    ('gaia', 'conversation', 'user_status_set__user_id'): ('gaia', 'user'),
    ('gaia', 'advertise_conver_stats', 'doctor_id'): ('gaia', 'doctor'),
    ('artemis', 'messagededuct', 'account__doctor_id'): ('gaia', 'doctor'),
    ('artemis', 'pvdeduct', 'account__doctor_id'): ('gaia', 'doctor'),
    ('artemis', 'merchantpromote', 'doctor_id'): ('gaia', 'doctor'),
    ('artemis', 'promotemerchantdaily', 'merchant_id'): ('gaia', 'merchant'),
    ('artemis', 'promoteservicedaily', 'promote__service_id'): ('gaia', 'service'),
    ('gaia', 'adwhitelist', 'doctor_id'): ('gaia', 'doctor'),
    ('gaia', 'doctor', 'business_group'): ('gaia', 'team'),
    ('gaia', 'merchant', 'doctor__business_group'): ('gaia', 'team'),
    ('gaia', 'maidanorder', 'payment_id'): ('gaia', 'maidanpayment'),
    ('gaia', 'merchantstatdailydata', 'merchant_id'): ('gaia', 'merchant'),
    ('mimas', 'sendanswer', 'user_id'): ('gaia', 'user'),
}

EXPORT_LOG = {'host': '192.168.168.142', 'port': 6379, 'db': 1}

# 是否使用邮箱验证
USE_VERIFY_CODE = False

CELERY_TASK_SERIALIZER = 'pickle'
CELERY_RESULT_SERIALIZER = 'pickle'
CELERY_ACCEPT_CONTENT = ['pickle', 'json']

PUSH_COUPON_CHANNAL_ID = 93
MAX_BATCH_UPDATE_COUNT = 200

POINT_MALL_CHANNEL_ID = 48
