# -*- coding:utf-8 -*-

"""
Django settings for gengmei project.

For more information on this file, see
https://docs.djangoproject.com/en/1.7/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/1.7/ref/settings/
"""

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
import os
import logging
import helios.rpc

BASE_DIR = os.path.dirname(os.path.dirname(__file__))
_URL_PREFIX = ""
DATETIME_FORMAT = 'Y-m-d H:i:s'
DATE_FORMAT = 'Y-m-d'

# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/1.7/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = 'r@ym7!c!y9&me*u873hq)t+sov)@f1l0+3u!4^rf)$3t5#d1&u'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = False

TEMPLATE_DEBUG = True

ALLOWED_HOSTS = ['*']


# Application definition

INSTALLED_APPS = (
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'django.contrib.sites',

    'api',
    'fileserver',
    'raven.contrib.django.raven_compat',
    'django_jinja',
)

MIDDLEWARE_CLASSES = (
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.auth.middleware.SessionAuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
)

TEMPLATE_CONTEXT_PROCESSORS = (
    "django.core.context_processors.debug",
    "django.core.context_processors.i18n",
    "django.core.context_processors.static",
    "django.contrib.auth.context_processors.auth",
    "django.core.context_processors.request",
    "django.core.context_processors.media",
    "django.contrib.messages.context_processors.messages",
)

STATICFILES_DIRS = (
)

STATICFILES_FINDERS = (
    'django.contrib.staticfiles.finders.FileSystemFinder',
    'django.contrib.staticfiles.finders.AppDirectoriesFinder',
    # 'django.contrib.staticfiles.finders.DefaultStorageFinder',
)


TEMPLATE_LOADERS = (
    'django_jinja.loaders.FileSystemLoader',
    'django_jinja.loaders.AppLoader',
)


TEMPLATE_DIRS = (
    BASE_DIR + '/templates',
)

ROOT_URLCONF = 'gengmei.urls'

WSGI_APPLICATION = 'gengmei.wsgi.application'


LANGUAGE_CODE = 'zh-cn'

TIME_ZONE = 'Asia/Shanghai'

USE_I18N = True

USE_L10N = True

# USE_TZ = True

SITE_ID = 1


# 邮件发送参数配置
EMAIL_HOST='smtp.exmail.qq.com'
EMAIL_HOST_USER='doctor@wanmeizhensuo.com'
EMAIL_HOST_PASSWORD='1812bar'
DEFAULT_FROM_EMAIL = 'doctor@wanmeizhensuo.com'
BrokenLinkEmailsMiddleware = True
SERVER_EMAIL = 'doctor@wanmeizhensuo.com'
EMAIL_PORT = 25

# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/1.7/howto/static-files/

MEDIA_ROOT = BASE_DIR + '/media/'
MEDIA_URL = _URL_PREFIX + '/medical/media/'

STATIC_ROOT = BASE_DIR + '/static/'
STATIC_URL = _URL_PREFIX + '/static/'

FILE_UPLOAD_MAX_MEMORY_SIZE = 0
# 300天才过期，认为用户只要登录就不会退出
SESSION_COOKIE_AGE = 60 * 60 * 24 * 300               # Age of cookie, in seconds (default: 300 weeks).

QINIU_ACCESS_KEY = "UPCOYIJkZOMcdd9FDzpBqYjzWUh55fBpVi3AhWpL"
QINIU_SECRET_KEY = "z5YvpDDSam_JE345Z8J_f3TufzelOW2VOGNoBl9e"
API_HOST = "http://www.wanmeizhensuo.com"

BEAUTIFUL_ACCESS_KEY = ''
BEAUTIFUL_SECRET_KEY = ''

_API_URL_PREFIX = API_HOST
_WEB_URL_PREFIX = API_HOST


RAVEN_CONFIG = {
    'dsn': 'http://9f8992868f0348efaca2f4375e8db1df:11764cbbdb1440c38142c9e1a1e663ac@sentry.igengmei.com/131',
}

LOG_DIR = '/data/log/hermes/app/'
logging.basicConfig(
    level=logging.INFO,
    format='%(asctime)s %(levelname)s %(module)s.%(funcName)s Line:%(lineno)d  %(message)s',
    filename=os.path.join(LOG_DIR, 'filelog.log'),
)
LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,

    'formatters': {
        'verbose': {
            'format': '%(asctime)s %(levelname)s %(module)s.%(funcName)s Line:%(lineno)d  %(message)s'
        },
        'simple': {
            'format': '%(levelname)s %(message)s'
        },
    },

    'handlers': {
        'null': {
            'level': 'DEBUG',
            'class': 'django.utils.log.NullHandler',
        },
        'console': {
            'level': 'DEBUG',
            'class': 'logging.StreamHandler',
            'formatter': 'simple'
        },
        'mail_admins': {
            'level': 'ERROR',
            'class': 'django.utils.log.AdminEmailHandler'
        },

        # 默认的服务器Log(保存到log/filelog.log中, 通过linux的logrotate来处理日志的分割
        'default': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'filelog.log'),
            'formatter': 'verbose',
        },

        # 默认的服务器ERROR log
        'default_err': {
            'level': 'ERROR',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'error_logger.log'),
            'formatter': 'verbose',
        },
        'exception_logger': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'exception_logger.log'),
            'formatter': 'verbose',
        },
        'ticker_logger': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'ticker_logger.log'),
            'formatter': 'verbose',
        },
        'push_logger': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'push_logger.log'),
            'formatter': 'verbose',
        },
        'elapsed_logger': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'elapsed_logger.log'),
            'formatter': 'verbose',
        },
        'info_logger': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'info_logger.log'),
            'formatter': 'verbose',
        },
        'auth_logger': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'auth_logger.log'),
            'formatter': 'verbose',
            },
        'webproblem_logger': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'webproblem_logger.log'),
            'formatter': 'verbose',
        },
        'sql_logger': {
            'level': 'DEBUG',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'sql.log'),
            'formatter': 'verbose',
        },
    },

    'loggers': {
        # 默认都交给django了
        'django': {
            'handlers': ['default'],
            'propagate': True,
            'level': 'INFO',
        },
        'django.request': {
            'handlers': ['default_err'],
            'level': 'ERROR',
            'propagate': False,
        },
        'exception_logger': {
            'handlers': ['exception_logger'],
            'level': 'INFO',
            'propagate': False,
        },
        'ticker_logger': {
            'handlers': ['ticker_logger'],
            'level': 'INFO',
            'propagate': False,
        },
        'push_logger': {
            'handlers': ['push_logger'],
            'level': 'INFO',
            'propagate': False,
        },
        'elapsed_logger': {
            'handlers': ['elapsed_logger'],
            'level': 'INFO',
            'propagate': False,
        },
        'info_logger': {
            'handlers': ['info_logger'],
            'level': 'INFO',
            'propagate': False,
        },
        'auth_logger': {
            'handlers': ['auth_logger'],
            'level': 'INFO',
            'propagate': False,
        },
        'err_logger': {
            "handlers": ['default_err'],
            'level': "ERROR",
            "propagate": False,
        },
    }
}


TEST_RUNNER = 'django.test.runner.DiscoverRunner'
DEFAULT_JINJA2_TEMPLATE_EXTENSION = '.jinja.html'

RPC_URL = 'http://10.129.148.20/api/'
RPC_SECRET = 'basic:XYLxLlkTFe89EnzR2e0bF90PqT29NkK5R9kaY50LhgIVIhzCZDiPT4C5AIO894lFHA0y+29ziq589m+LnCn2Iw=='
RPC_INVOKER = helios.rpc.RPCFactory(RPC_URL, RPC_SECRET, debug=DEBUG).create_invoker()


# 广点通
APPID_GDT = '639234809'
ADID_GDT = '55108'
ENCRYPT_KEY_GDT = '65772fc7658ffef4'  # 加密密钥
SIGN_KEY_GDT = '41a8b982321e80a9'  # 签名密钥
CONV_TYPE_GDT = 'MOBILEAPP_ACTIVATE'
URL_GDT = 'http://t.gdt.qq.com/conv/app/'

###2016-4-19 add by WangChengLiang
GDT_URL = 'http://t.gdt.qq.com/conv/app/'
GDT_SIGN_KEY = 'bec031e37babd08f'
GDT_ENCRYPT_KEY = 'BAAAAAAAAAAAFzsH'
GDT_CONV_TYPE = 'MOBILEAPP_ACTIVITE'
GDT_ADVER_ID = '1522439'
###end###
