# coding=utf-8

import datetime,sys
from celery.schedules import crontab
from gm_types.gaia import SERVICE_ORDER_TYPE, NotificationType, XCX_LANDING_PAGE
from gm_types.mimas import GRABBING_PLATFORM
from gm_types.user_hierarchy import UserRightType
from django.utils import six


ORDER_CAN_BE_REQUEST_REFUND = True

# ====================================================================================================
# ============================================时间个数=================================================
# ====================================================================================================
TIME_CAN_ACCEPT_CALL = (datetime.time(9, 0, 0), datetime.time(19, 0, 0))
SUOZHANG_WOKRING_TIME = (datetime.time(9, 0, 0), datetime.time(23, 59, 59))
REMIND_TIME_BEFORE_ORDER_EXPIRED = 600  # 10 mins before order timeout
ORDER_TIMEOUT = 1800
MAX_LOGIN_ATTEMPTES = 10
PRIVATE_MSG_SHOW_TIME = 1800
SEND_MSG_INTERVAL = 6 * 60 * 60  # six hours
DOCTOR_DEFAULT_URL = 'http://hera.s.igengmei.com/2015/12/24/a9fcb0f072'
AUTOCOMPLETE_MAX_WORDS = 50
AUTOCOMPLETE_MAX_WORDS_POS = 100

CHINA_TAG_ID = 259

""" PORTRAITS """
CONSULTING_DOCTOR_PORTRAIT = 'http://pic.igengmei.com/2015/05/11/b3eecb13e1-half'
CONSULTING_DEFAULT_USER_PORTRAIT = 'http://hera.s.igengmei.com/user/icon14@2x.png'

""" DIARY """
DIARY_COVER_DEFAULT = 'http://hera.s.igengmei.com/2015/10/16/61b745cb36'
DEFAULT_DIARY_COVER_DICT = {
    'image': DIARY_COVER_DEFAULT,
    'image_thumb': DIARY_COVER_DEFAULT + '-thumb',
    'image_half': DIARY_COVER_DEFAULT + '-half',
    'image_wide': DIARY_COVER_DEFAULT + '-w',
}

# LINKS
API_HOST = 'http://backend.igengmei.com/'
HTTPS_HOST = 'https://backend.igengmei.com/'
API_HOST_GENGMEI = 'http://backend.gengmei.cc/'
WEB_API_HOST = 'http://m.igengmei.com/'
WEB_API_HOST_GENGMEI = 'http://m.gengmei.cc/'
PCWEB_API_HOST = 'http://www.igengmei.com'

WECHAT_SMALL_APPID = 'wx113018c998de9eaf'
WECHAT_SMALL_APPSECRET = '328083f0cbb131c7de3b3920eed8ddaf'
# 微信小程序的原始Id
WECHAT_SMALL_USER_NAME = 'gh_566b862e19b3'

WECHAT_SMALL_SHUDONG_APPID = 'wx7e2202362ef7ef77'
WECHAT_SMALL_SHUDONG_APPSECRET = '8d4e966ac0ac23f31fe5fc9b76779518'

QINIU_HOST = "http://pic.igengmei.com"
WEIBO_SHARE_HOST = 'http://m.igengmei.com'
# 他人主页背景图
PERSONAL_HOME_BG_IMAGE = 'http://hera.s.igengmei.com/2017/05/08/552a174ccb'

# "我" 主页背景图
MY_HOME_BG_IMAGE = 'http://hera.s.igengmei.com/itemwiki/2017/11/24/18eb0d92f3'

PK_TOPICS = {}

# 美购综合筛选器
SHARE_GET_CASHBACK = '1'
IS_FLOOR_PRICE = '2'
HOSPITAL_TYPE = '3'  # public
RATING_GTE = '4'
IS_SECKILL = '5'
IS_STAGE = '6'
IS_INSURANCE = '7'
# 740新增
HOSPITAL_TYPE_PUBLIC = '11'
HOSPITAL_TYPE_PRIVATE = '8'
HOSPITAL_TYPE_OVERSEA = '9'
SERVICE_COUPONS = '10'
# 740 筛选条，前三固定栏的key值,
EXTRA_FILTER_KEY = {
        IS_STAGE:u'支持分期',
        IS_SECKILL:u'限时秒杀',
        HOSPITAL_TYPE_PUBLIC:u'公立医生',
        HOSPITAL_TYPE_PRIVATE:u'民营医院',
        HOSPITAL_TYPE_OVERSEA:u'海外医院',
        SHARE_GET_CASHBACK:u'分享返现',
        SERVICE_COUPONS:u'红包补贴'
    }

# 区间筛选
GROUP_FILTER_ONE = '20'
GROUP_FILTER_ONE_ID1 = '1'
GROUP_FILTER_ONE_ID2 = '2'
GROUP_FILTER_ONE_ID3 = '3'
GROUP_FILTER_ONE_ID4 = '4'
GROUP_FILTER_ONE_ID5 = '5'
GROUP_FILTER_ONE_ID6 = '6'

GROUP_FILTER_DELETE_FOR_V6_GTE = [IS_FLOOR_PRICE, RATING_GTE]
GROUP_FILTER_FOR_EXPERT = [HOSPITAL_TYPE]
GROUP_FILTER = [
    {'id': SHARE_GET_CASHBACK, 'name': '分享返现', 'values': []},
    {'id': IS_FLOOR_PRICE, 'name': '底价', 'values': []},
    {'id': HOSPITAL_TYPE, 'name': '公立医院', 'values': []},
    {'id': RATING_GTE, 'name': '好评最多', 'values': []},
    {'id': IS_SECKILL, 'name': '秒杀', 'values': []},
    {'id': IS_STAGE, 'name': '支持分期', 'values': []},
    {'id': IS_INSURANCE, 'name': '支持保险', 'values': []},
    {

        'id': GROUP_FILTER_ONE,
        'name': '美购价格',
        'values': [
            {
                'id': GROUP_FILTER_ONE_ID1,
                'name': '500元以下',
            },
            {
                'id': GROUP_FILTER_ONE_ID2,
                'name': '500-1000元',
            },
            {
                'id': GROUP_FILTER_ONE_ID3,
                'name': '1000-2000元',
            },
            {
                'id': GROUP_FILTER_ONE_ID4,
                'name': '2000-5000元',
            },
            {
                'id': GROUP_FILTER_ONE_ID5,
                'name': '5000-10000元',
            },
            {
                'id': GROUP_FILTER_ONE_ID6,
                'name': '10000元以上',
            },
        ]
    },
]

VIDEO_TAG_ID = 4706   # 如果有小视频 就给日记本添加视频日记的tag

# 价格区间
MIN_PRICE = 0
MAX_PRICE = 100000
GROUP_FILTER_V1 = [
    {
        'name': u'医院类型',
        'tags': [
            {'id': HOSPITAL_TYPE_PUBLIC, 'name': EXTRA_FILTER_KEY[HOSPITAL_TYPE_PUBLIC]},
            {'id': HOSPITAL_TYPE_PRIVATE, 'name': EXTRA_FILTER_KEY[HOSPITAL_TYPE_PRIVATE]},
            {'id': HOSPITAL_TYPE_OVERSEA, 'name': EXTRA_FILTER_KEY[HOSPITAL_TYPE_OVERSEA]},
        ],
        'type': 0,
        'min_price': MIN_PRICE,
        'max_price': MAX_PRICE,
    },
    {
        'name': u'促销优惠',
        'tags': [
            {'name': EXTRA_FILTER_KEY[IS_SECKILL], 'id': IS_SECKILL},
            {'name': EXTRA_FILTER_KEY[SERVICE_COUPONS], 'id':SERVICE_COUPONS},
            {'name': EXTRA_FILTER_KEY[SHARE_GET_CASHBACK], 'id':SHARE_GET_CASHBACK},
        ],
        'type': 0,
        'min_price': MIN_PRICE,
        'max_price': MAX_PRICE,
    },
    {
        'name': '价格区间',
        'tags': [],
        'type': 1,    # 0 = 是医生资质、医院品牌、医院规模： 1 = 价格区间
        'min_price': MIN_PRICE,
        'max_price': MAX_PRICE,
    },
]

# 筛选器 added in 765
FILTER_ALL = {
    u'医院类型':{
        HOSPITAL_TYPE_PUBLIC: EXTRA_FILTER_KEY[HOSPITAL_TYPE_PUBLIC],
        HOSPITAL_TYPE_PRIVATE: EXTRA_FILTER_KEY[HOSPITAL_TYPE_PRIVATE],
        HOSPITAL_TYPE_OVERSEA: EXTRA_FILTER_KEY[HOSPITAL_TYPE_OVERSEA],
                },
    u'促销优惠':{
        IS_SECKILL: EXTRA_FILTER_KEY[IS_SECKILL],
        SERVICE_COUPONS: EXTRA_FILTER_KEY[SERVICE_COUPONS],
        SHARE_GET_CASHBACK: EXTRA_FILTER_KEY[SHARE_GET_CASHBACK],
    },
    u'更美服务':{IS_STAGE: EXTRA_FILTER_KEY[IS_STAGE]},
    u'特色专题':{},
    u'价格区间':{}
}

# 740 筛选条，2倍图标
EXTRA_F_ICON_2X = {
    HOSPITAL_TYPE_PUBLIC:'http://hera.s.igengmei.com/2017/07/19/8b74bb7cef',
    HOSPITAL_TYPE_PRIVATE:'http://hera.s.igengmei.com/2017/07/19/aed9668ebd',
    HOSPITAL_TYPE_OVERSEA:'http://hera.s.igengmei.com/2017/07/19/e8e7611877',
    IS_STAGE:'',
    IS_SECKILL:'http://hera.s.igengmei.com/2017/07/19/01bc231ec8',
    SHARE_GET_CASHBACK:'http://hera.s.igengmei.com/2017/07/19/d77449079d',
    SERVICE_COUPONS:'http://hera.s.igengmei.com/2017/07/19/f86e64fce0',
}
EXTRA_F_ICON_3X = {
    HOSPITAL_TYPE_PUBLIC:'http://hera.s.igengmei.com/2017/07/19/7d59ed820f',
    HOSPITAL_TYPE_PRIVATE:'http://hera.s.igengmei.com/2017/07/19/111e31cb15',
    HOSPITAL_TYPE_OVERSEA:'http://hera.s.igengmei.com/2017/07/19/54147d3135',
    IS_STAGE:'',
    IS_SECKILL:'http://hera.s.igengmei.com/2017/07/19/815a440eae',
    SHARE_GET_CASHBACK:'http://hera.s.igengmei.com/2017/07/19/45e8e6839f',
    SERVICE_COUPONS:'http://hera.s.igengmei.com/2017/07/19/8d9dde7abb',
}

# 传给gaia筛选器的filter参数
GROUP_FILTER_MAP = {
    SHARE_GET_CASHBACK: {'key': 'share_get_cashback', 'val': True},
    HOSPITAL_TYPE: {'key': 'hospital_type', 'val': '0'},
    IS_SECKILL: {'key': 'is_seckill', 'val': True},
    GROUP_FILTER_ONE: {
        GROUP_FILTER_ONE_ID1: {"le": 500},
        GROUP_FILTER_ONE_ID2: {"gte": 500, "le": 1000},
        GROUP_FILTER_ONE_ID3: {"gte": 1000, "le": 2000},
        GROUP_FILTER_ONE_ID4: {"gte": 2000, "le": 5000},
        GROUP_FILTER_ONE_ID5: {"gte": 5000, "le": 10000},
        GROUP_FILTER_ONE_ID6: {"gte": 10000},
    },
    IS_FLOOR_PRICE: {'key': 'is_floor_price', 'val': True},
    RATING_GTE: {'key': 'rating_gte', 'val': 4.5},
    IS_STAGE: {'key': 'is_stage', 'val': True},
    IS_INSURANCE: {'key': 'is_insurance', 'val': True},
    # 740新增，不在前端展示，
    HOSPITAL_TYPE_PUBLIC:{'key': 'hospital_type_list', 'val': '0'},
    HOSPITAL_TYPE_PRIVATE: {'key': 'hospital_type_list', 'val': '1'},
    HOSPITAL_TYPE_OVERSEA: {'key': 'hospital_type_list', 'val': '9'},
    SERVICE_COUPONS: {'key': 'service_coupons', 'val': 1},  # 1 过滤，0不过滤

}

# 传给gaia筛选器的filter参数 >= 7.4.0
GROUP_FILTER_MAP_V1 = {
    HOSPITAL_TYPE_PUBLIC:{'key':'hospital_type_list','val':['0']},
    HOSPITAL_TYPE_PRIVATE:{'key':'hospital_type_list','val':['1']},
    HOSPITAL_TYPE_OVERSEA:{'key':'hospital_type_list','val':['9']},

    # '5':{'key':'hospital_brand', 'val':{'key':'city_count','val':3}},
    # '6':{'key':'hospital_brand', 'val':{'key':'chain_count','val':3}},
    # '7':{'key':'hospital_brand', 'val':{'key':'is_high_quality','val':True}},

    IS_SECKILL:{'key': 'is_seckill', 'val': True},
    SERVICE_COUPONS:{'key': 'service_coupons', 'val': 1},
    SHARE_GET_CASHBACK:{'key': 'share_get_cashback', 'val': True},
    IS_STAGE: {'key': 'is_stage', 'val': True},
}
# Gengmei客服测试用talent_id
GENGMEI_TENANT_ID = ''
GENGMEI_KEFU_USER_ID = None
GENGMEI_KEFU_PERSON_ID = ''

# 免费医美定制
SELECT_PROJECT_ID = 1

SELECT_BUDGET_ID = 2
SELECT_BUDGET_SUB_ID0 = 20
SELECT_BUDGET_SUB_ID1 = 21
SELECT_BUDGET_SUB_ID2 = 22
SELECT_BUDGET_SUB_ID3 = 23

SELECT_CURE_ID = 3
SELECT_CURE_SUB_ID0 = 30
SELECT_CURE_SUB_ID1 = 31
SELECT_CURE_SUB_ID2 = 32
SELECT_CURE_SUB_ID3 = 33

SELECT_RECOVER_ID = 4
SELECT_RECOVER_SUB_ID0 = 40
SELECT_RECOVER_SUB_ID1 = 41
SELECT_RECOVER_SUB_ID2 = 42
SELECT_RECOVER_SUB_ID3 = 43

# 参考gm_types.gaia  PLAN_TYPE/TREATMENT_TYPE/RECOVER_TIME_TYPE 只需要修改这个映射关系
FREE_CUSTOM_KEY_VAL = {
    SELECT_BUDGET_SUB_ID0: u'1',  # 1000元以内
    SELECT_BUDGET_SUB_ID1: u'4',  # 1000-10000元
    SELECT_BUDGET_SUB_ID2: u'5',  # 10000-20000元
    SELECT_BUDGET_SUB_ID3: u'6',  # 20000元以上

    SELECT_CURE_SUB_ID0: u'0',  # 不限
    SELECT_CURE_SUB_ID1: u'1',  # 手术(含微创手术)
    SELECT_CURE_SUB_ID2: u'2',  # 注射(微创)
    SELECT_CURE_SUB_ID3: u'3',  # 光电(无创)

    SELECT_RECOVER_SUB_ID0: u'4',  # 无恢复周期
    SELECT_RECOVER_SUB_ID1: u'1',  # 1-3天
    SELECT_RECOVER_SUB_ID2: u'5',  # 3-14天
    SELECT_RECOVER_SUB_ID3: u'6',  # 14天以上

}

PROMOTE_AREA_SERVICE = {}

# type=0单选|1多选(可删除的)|2多选(不可删除的)
FREE_CUSTOM_DATA = [
    {
        "project_id": SELECT_PROJECT_ID,
        "necessary": False,
        "title": "有无明确想做的项目?",
        "type": 1,
        "items": [
            {
                "name": "选择项目"
            }
        ]
    },
    {
        "project_id": SELECT_BUDGET_ID,
        "necessary": True,
        "title": "能接受预算范围?",
        "type": 0,
        "items": [
            {
                "item_id": SELECT_BUDGET_SUB_ID0,
                "name": "1000元以内"
            },
            {
                "item_id": SELECT_BUDGET_SUB_ID1,
                "name": "1000-10000元"
            },
            {
                "item_id": SELECT_BUDGET_SUB_ID2,
                "name": "10000-20000元"
            },
            {
                "item_id": SELECT_BUDGET_SUB_ID3,
                "name": "20000元以上"
            }
        ]
    },
    {
        "project_id": SELECT_CURE_ID,
        "necessary": True,
        "title": "能接受治疗方式?",
        "type": 2,
        "items": [
            {
                "item_id": SELECT_CURE_SUB_ID1,
                "name": "手术(含微创手术)"
            },
            {
                "item_id": SELECT_CURE_SUB_ID2,
                "name": "注射(微创)"
            },
            {
                "item_id": SELECT_CURE_SUB_ID3,
                "name": "光电(无创)"
            }
        ]
    },
    {
        "project_id": SELECT_RECOVER_ID,
        "necessary": True,
        "title": "能接受的恢复周期?",
        "type": 0,
        "items": [
            {
                "item_id": SELECT_RECOVER_SUB_ID0,
                "name": "无恢复周期"
            },
            {
                "item_id": SELECT_RECOVER_SUB_ID1,
                "name": "1-3天"
            },
            {
                "item_id": SELECT_RECOVER_SUB_ID2,
                "name": "3-14天"
            },
            {
                "item_id": SELECT_RECOVER_SUB_ID3,
                "name": "14天以上"
            }
        ]
    }
]

# 医生机构tags显示的个数
DOCTOR_SHOW_TAGS_NUM = 6

# 400
USER_SAFE_TOAST = u'在更美app下单，享受更多消费保障，有问题请随时联系客服'

# CUSTOM_SERVICE_PHONE = 'tel://4006899900,,6666'
CUSTOM_SERVICE_PHONE = 'tel://4006999227,,6666'
CUSTOM_SERVICE_PHONE_CALL_TIP = u'如不能接通，请按提示输入分机号 {ext}'

# CSC_400_EXT_LITERAL = u'4006-899-900转6666'
CSC_400_EXT_LITERAL = u'4006-999-227转6666'
# CSC_400_CALL_URL = 'tel://4006899900,,6666'
CSC_400_CALL_URL = 'tel://4006999227,,6666'

# 400电话咨询入口开关
IS_ACCEPT_CALL = False
# 400 END

SUOZHANG_UID = 22
SUOZHANG_PORTRAIT = "http://hera.s.igengmei.com/2015/09/25/150fb7df76"

# 弹窗提醒次数
APP_STARTUP_COUNT = 30

DEFAULT_ZONE_ICON = 'http://pic.igengmei.com/2015/08/22/0055662b14-thumb'

NEED_CLICK_REDPOINT = True

QR_URL = ['http://toufang.gengmei.cc/benzhan/qsgm/',
          'http://weixin.qq.com/r/DkwtNSXE_3iErWFW9xkc',
          'http://wap.fw.gov315.com',
          'http://winsafe.cn',
          'http://www.matrifill.com']

PAY_TOGGLE = {
    'alipay': True,
    'huabei': True,
    'wechat': True,
    'applepay': True,
    'xiaoying': True,
    'yinuo': True,
    'renmai': True,
    'maidan': True,
    'zhongan': True,
    'yirendai': True,
    'renmai_credit': True,
}

QQ_MAP_KEYS = [
    'QVMBZ-KZFRJ-VQ5F6-FMJIJ-SCJN6-WNFFS',
    '2RJBZ-EWTW3-ANB3A-3O6KS-SDYRK-EQFFO',
    '2LZBZ-K353F-ZQKJG-JGT7Z-PQYD2-YVBLE',
    'D7FBZ-SRGKG-AU3QI-IGMXR-63EU3-3PBOA',
    'H52BZ-JH2WX-EAB4T-TXW23-SNBLQ-GNFNQ',
    'RL2BZ-CASW3-MJ53C-3JCUR-IEGRO-TABLU',
    'NJIBZ-L2H3U-ZWLV6-4W3PK-H7DFF-OSFUM',
    'ZOBBZ-FP2WX-CA74G-TZC24-MPSL7-22BD4',
    'TENBZ-AZ53P-JRTDP-LUIQ2-KNVE6-XNF4X',
    'L7GBZ-JKMWP-HKJDV-LQPEC-QQ2M7-D6BAT',
]

ORDER_COMPLETE_SHARE_COUPONGIFT_ID = 4
ORDER_COMPLETE_SHARE_CHANNEL_ID = 1

# APP更新次数
APP_UPDATE_COUNT = 30

SPECIAL_COUPON_CHANNEL = 22

IOS_UPDATE = False

ANDROID_UPDATE = True

# 美购广告插入位置
SERVICE_INSERT_INDEX = 3

# 日记本封面默认图
NO_SERVICE_DIARY_COVER = 'http://hera.s.igengmei.com/2016/08/27/1c6bca1ee7'
SERVICE_DIARY_COVER = 'http://hera.s.igengmei.com/2016/08/27/c93b32447e'
DEFAULT_DIARY_COVER = 'http://hera.s.igengmei.com/2017/03/10/0d29febe31-thumb'

# 意见反馈客服分组
FEEDBACK_CS_GROUP = ''

GRAY_TEST = False

STAGGER_FLAG = False

# 手机号医生是否可见
PHONE_CAN_SEE_BY_DOCTOR = True

# 任买分期默认期数
RENMAI_INSTALLMENT_PERIOD = 12

# hybrid分期提示文案
RENMAI_INSTALLMENT_COMMENT_HYBRID = u'首付预约金，尾款<span style="color: #FF7690">￥{price}</span>起 x {period}期'

# 客户端文案
RENMAI_INSTALLMENT_COMMENT = u'首付预约金，尾款<ems>￥{price}</ems>起 x {period}期'

# 买单标签
MAIDAN_TAGS = [
    u'双眼皮',
    u'假体隆鼻',
    u'玻尿酸',
    u'自体脂肪填充',
    u'吸脂',
    u'肉毒素除皱',
    u'瘦脸针',
    u'水光针',
    u'激光美肤',
    u'假体隆下巴',
    u'补牙',
    u'牙齿美白/洗牙',
    u'牙齿矫正',
    u'超声刀',
    u'热玛吉',
    u'热拉提',
    u'假体隆胸',
    u'修复',
    u'毛发移植',
    u'韩式半永久',
    u'脱毛',
    u'其他',
]

AB_TEST_LIST = []

# IOS默认的idfa参数
IOS_DEFAULT_PARAM = '00000000-0000-0000-0000-000000000000'

# 秒杀老版本默认图片
SECKILL_DEFAULT_PIC = 'http://hera.s.igengmei.com/2016/11/04/698215bc54'

# 400电话咨询入口开关
IS_ACCEPT_CALL = False

VIDEO_TAB_SHOW_FLAG = False

LIVE_TAB_SHOW_FLAG = True

# 转盘领礼包URL
COUPON_GIFT_URL = 'http://m.igengmei.com/coupon_gift'
COUPON_GIFT_SWITCH = True

DIARY_SORT_WHITE_LIST = ['0', '2', '4', '6', '8']

DEFAULT_ZONE_ICONS = [
    'http://hera.s.igengmei.com/tag/2016/12/06/f14638ba12',
    'http://hera.s.igengmei.com/tag/2016/12/06/b56acef47b',
    'http://hera.s.igengmei.com/tag/2016/12/06/5ec629f70a',
    'http://hera.s.igengmei.com/tag/2016/12/06/71916b96b0',
    'http://hera.s.igengmei.com/tag/2016/12/06/02228b95e1',
    'http://hera.s.igengmei.com/tag/2016/12/06/65638cb067',
    'http://hera.s.igengmei.com/tag/2016/12/06/97e984300b',
    'http://hera.s.igengmei.com/tag/2016/12/06/716269ae2e',
]

# 3X的icon

INDEX_TAB_CONFIG = [
    {
        'icon_normal': "",
        'icon_pressed': "",
        'colour_normal': "FFEC8B",
        'colour_pressed': "FF0000"
    },
    {
        'icon_normal': "",
        'icon_pressed': "",
        'colour_normal': "FFEC8B",
        'colour_pressed': "FF0000"
    },
    {
        'icon_normal': "",
        'icon_pressed': "",
        'colour_normal': "FFEC8B",
        'colour_pressed': "FF0000"
    },
    {
        'icon_normal': "",
        'icon_pressed': "",
        'colour_normal': "FFEC8B",
        'colour_pressed': "FF0000"
    },
    {
        'icon_normal': "",
        'icon_pressed': "",
        'colour_normal': "FFEC8B",
        'colour_pressed': "FF0000"
    }
]

# 2X的icon
INDEX_TAB_CONFIG_2X = [
    {
        'icon_normal': "",
        'icon_pressed': "",
        'colour_normal': "FFEC8B",
        'colour_pressed': "FF0000"
    },
    {
        'icon_normal': "",
        'icon_pressed': "",
        'colour_normal': "FFEC8B",
        'colour_pressed': "FF0000"
    },
    {
        'icon_normal': "",
        'icon_pressed': "",
        'colour_normal': "FFEC8B",
        'colour_pressed': "FF0000"
    },
    {
        'icon_normal': "",
        'icon_pressed': "",
        'colour_normal': "FFEC8B",
        'colour_pressed': "FF0000"
    },
    {
        'icon_normal': "",
        'icon_pressed': "",
        'colour_normal': "FFEC8B",
        'colour_pressed': "FF0000"
    }
]

DANMU_TIME = 60

# 任买提额项开关
RENMAI_CREDIT_TOGGLE = {
    'company': True,   # 公司信息提额
    'contact': True,   # 联系人信息
    'taobao': True,    # 淘宝登录
    'phone_operator': True,    # 手机运营商
    'bank_bill': False,         # 任买现在没有做银行账单接口, 始终为False.
    'credit_email': True,      # 信用卡邮箱
    'credit_report': True,     # 征信报告
}

# ztth400 config
ZTTH_400_KEY_SECRET = {
    'pxahoVsHou1vekxE': 'LL#^wFk%mXV6!WUM',
}

# 灰度开关
NEW_USER_GRAY = 0

# 美购首页悬浮红包开关
REGISTER_COUPONGIFT = 1
REGISTER_COUPONGIFT_ID_LIST = [104]
REGISTER_COUPONGIFT_CHANNEL_ID = 40

# API签名校验开关
GM_ANTISPAM = False
# API签名有效时长
GM_ACCESS_TOKEN_TTL = 18 * 60
# API Access Key
GM_ACCESS_KEY = "DHZd38GsKezs$@V9LxQx$wHo8hvqCR=#"


BROKER_URL = 'redis://192.168.168.142:6379/4'
BROKER_TRANSPORT_OPTIONS = {'visibility_timeout': 259200}  # 72 hours
CELERY_TIMEZONE = 'Asia/Shanghai'
CELERYBEAT_SCHEDULE = {
    'doctors2redis': {
        'task': 'api.tasks.doctors2redis',
        'schedule': crontab(minute=0, hour=3),
        'args': ()
    },
    'hospital2redis': {
        'task': 'api.tasks.hospital2redis',
        'schedule': crontab(minute=0, hour=3),
        'args': ()
    },
    'doctor_tags': {
        'task': 'api.tasks.doctor_tags',
        'schedule': crontab(minute=20, hour=5),
        'args': ()
    },
    'tag2redis': {
        'task': 'api.tasks.tag2redis',
        'schedule': crontab(minute=0, hour=6),
        'args': ()
    },
    'autocomplete_words': {
        'task': 'api.tasks.autocomplete_words',
        'schedule': crontab(minute=30, hour=4),
        'args': ()
    },
}

# 订单尾款花呗分期开关
HOSPITAL_PAY_HUABEI_SWITCH = False

# 美购专场图片
# SPECIAL_INFO_URL = u'http://hera.s.igengmei.com/slide/2017/04/17/67d1a5518e'
SPECIAL_INFO_URL = u'http://hera.s.igengmei.com/serviceactivity/2018/08/28/a1bf338347'

# 首页医生资格查询显示开关
INDEX_DOCTOR_SEARCH_SHOW = True

# 2017.5 分享文案开关
NEW_SHARE_DATA = False

# 搜索综合排序
SEARCH_SORT_LIST_710 = ['suggestion_keywords', 'recommend', 'diary', 'pgc', 'user']

SEARCH_SORT_LIST_740 = ['suggestion_keywords', 'ranklist', 'recommend', 'diary', 'pgc', 'user']

# 结构大改版中灰度值
# INDEX_CONFIG_GREY_NUM = ['0', 'F', '7', '5', 'A']

# 分享购相关
FXG_URL = '/hybrid/fenxianggou/homepage'
FXG_SHOW_IN_SETTLEMENT = True
FXG_SHOW_IN_DASHBOARD = True

ANTI_SPAM_BLAC_DEVICE_KLIST = ['017746774461753', ]

START_NUM_UPLIMIT = 1200

# 用户权益特权图标
USER_RIGHTS_ICON_UNLOCKED = {
    UserRightType.Identify: 'http://hera.s.igengmei.com/2017/05/19/11589ba542',
    UserRightType.Points: 'http://hera.s.igengmei.com/2017/05/19/5abfe37895',
    UserRightType.Video: 'http://hera.s.igengmei.com/2017/05/19/9ffec973de',
    UserRightType.Free_order: 'http://hera.s.igengmei.com/2017/05/19/f8af6e5bff',
    UserRightType.Free_experience: 'http://hera.s.igengmei.com/2017/05/19/5e0520cca9',
    UserRightType.Constellation: 'http://hera.s.igengmei.com/2017/05/19/0cc26f78cc',
}

USER_RIGHTS_ICON_LOCKED = {
    UserRightType.Identify: 'http://hera.s.igengmei.com/2017/05/19/5483b03733',
    UserRightType.Points: 'http://hera.s.igengmei.com/2017/05/19/ffb4c4b317',
    UserRightType.Video: 'http://hera.s.igengmei.com/2017/05/19/c21ee15623',
    UserRightType.Free_order: 'http://hera.s.igengmei.com/2017/05/19/fe28682f8a',
    UserRightType.Free_experience: 'http://hera.s.igengmei.com/2017/05/19/56195285d5',
    UserRightType.Constellation: 'http://hera.s.igengmei.com/2017/05/19/26f1b87b6f',
}
# 个人页倾斜皇冠图
START_LEVEL_ICON = 'http://hera.s.igengmei.com/2017/05/25/e340c3f5a6'

# 高佣金项目说明
SERVICE_SPECIAL_DES_ICON = 'http://hera.s.igengmei.com/2017/07/10/9950841785'

SEARCH_NEW_SMART_RANK = ['3', '6']

SEARCH_SKU_GRAY = ['2','0','4','5']

SEARCH_SMART_SERVICE = ['1']

# 7.3.5 版本后美购首页，豆腐块模块开关True:显示，False:不显示
SERVICE_HOME_V3_STATIC_TEMPLATES = False

# 美分商城在个人中心的开关
POINT_MALL_SWITCH = False

VIDEO_GRAY_TYPE = [0]

SEARCH_DOCTOR_GRAY = ['0', '4']

FENXIANGGOU_CODE_BY_APP_VERSION_CACHE_TIME_SECOND = 1 * 60 * 60

CAN_GET_ADVERTISE_ORDER_LIST = [SERVICE_ORDER_TYPE.DEFAULT2, SERVICE_ORDER_TYPE.DEFAULT]
PERSONAL_SERVICE = ['0','1']    # PersonalCenter recommend services


# ============================================index悬浮活动相关配置==================================================
INDEX_FLOAT_ACTIVITY_SWITCH = True     # 开关True/False
# 开始时间
INDEX_FLOAT_ACTIVITY_START_TIME = datetime.datetime(2017, 9, 21, 0, 0, 0)
# 截止时间
INDEX_FLOAT_ACTIVITY_END_TIME = datetime.datetime(2017, 9, 24, 23, 59, 59)

# 活动图片
INDEX_FLOAT_ACTIVITY_PIC = 'http://hera.s.igengmei.com/activity/denglong-home.png'
# 个人页图片
INDEX_FLOAT_ACTIVITY_PERSON_PIC = 'http://hera.s.igengmei.com/activity/denglong-person.png'


FACE_REPORT_WITH_UINFO = ['7']  # 用户信息补全二，面部分析，add in 755
FACE_REPORT_WITH_UINFO_V1 = ['9', '3']  # 新版发布概率，add in 7630

USER_INFO_EXTRA_QA = {
    'question_one':u'何时开始你的变美大业',
    'answer_one':[
        {'id':1,'value':u'马上尝试'},
        {'id':2,'value':u'最近一个月'},
        {'id':3,'value':u'最近一个季度'},
        {'id':4,'value':u'最近半年'},
        {'id':5,'value':u'最近一年'}
    ],
    'question_two':u'准备付出多少银子',
    'answer_two':[
        {'id':6,'value':u'500元以下'},
        {'id':7,'value':u'2000元以下'},
        {'id':8,'value':u'5000元以下'},
        {'id':9,'value':u'10000元以下'},
        {'id':10,'value':u'20000元以下'},
        {'id':11,'value':u'价格不限'}
    ],
}

# 首页样式灰度开启
INDEX_V6_STYLE = False

# 首页灰度设备白名单
INDEX_V6_GATED_WHITE_LIST = [
    '862552030199852', '774AF4B1-7CDE-4FA1-8288-470D07660F2A', '869897027766335',
    '863363036614459','4841C5E0-DCE8-4108-9432-9E46631AACA3', '35CB0480-38A5-4E6E-B4FF-13081FFBFD29',
    '6A99CBB1-6738-4ED1-A042-199CA80AAB22', '357090075245365', '03FF92B1-71A9-4AC6-B05E-38AB103FD51D',
    '906660B7-4D93-4E78-8BA1-A0AC4BF2B3FA', '1123B2B4-4AC1-494B-8F5B-0DAEC3CFC182', 'E0072D3A-E9AD-42D2-BDDE-81D58AB64DBE'
]

# patch for client
RANKLIST_BACKGROUND = [
    'http://hera.s.igengmei.com/slide/2017/10/30/e6445b33cb',
    'http://hera.s.igengmei.com/slide/2017/10/30/e016fa5792',
    'http://hera.s.igengmei.com/slide/2017/10/30/f3cd229bb8',
    'http://hera.s.igengmei.com/slide/2017/10/30/219f2bf401',
    'http://hera.s.igengmei.com/slide/2017/10/30/a638b218a1',
]

# SENTINEL相关配置
SENTINEL = {
    # sentinel开关(非线上环境建议关闭)
    'enable': False,

    # sentinel服务器地址列表
    'sentinels': [
        ('192.168.168.142', 26379), ('192.168.168.142', 26380), ('192.168.168.142', 26381),
    ],

    # redis-master的地址，与master-name的映射
    'masters': {
        ('192.168.168.142', '6379'): "ac1e0876_18eb",
    },
}

# 用户新版任务中心，任务图标
# [u'签到拿豪礼', u'去发布评论', u'有问必答', u'验证美购订单', u'写日记']
UNI_TASK_IMG = [
    'http://hera.s.igengmei.com/2017/11/15/293f3d509e',
    'http://hera.s.igengmei.com/2017/11/15/d443617ef5',
    'http://hera.s.igengmei.com/2017/11/15/e309f3d7a1',
    'http://hera.s.igengmei.com/2017/11/15/e8c007354a',
    'http://hera.s.igengmei.com/2017/11/15/332360fe03'
]
# [u'累计评论{}次', u'累计点赞{}次', u'累计关注{}次', u'累计回答{}次']
# 顺序图标
MULTI_TASK_IMG = [
    'http://hera.s.igengmei.com/2017/11/17/69f7689517',
    'http://hera.s.igengmei.com/2017/11/15/d0c4538066',
    'http://hera.s.igengmei.com/2017/11/15/f5b8effbd2',
    'http://hera.s.igengmei.com/2017/11/15/7875902982',
    'http://hera.s.igengmei.com/2017/11/15/9643c3dfd3',
    'http://hera.s.igengmei.com/2017/11/15/4f4183da48',
    'http://hera.s.igengmei.com/2017/11/15/59a6b0c27c',
]
USER_COMPLETE_PORTRAIT = 'http://hera.s.igengmei.com/2017/11/15/ad5aa2fb83'
BIND_USER_PHONE = 'http://hera.s.igengmei.com/2017/11/15/1ee13412b3'

# 热门搜索词灰度值
POPULAR_SEARCH_KEYWORDS_GRAY = ['0', '2', '4', '6', '8', 'A', 'C', 'E']

# 是否在终端显示：PROFILE-LOG
PROFILE = False

# 美分商城在个人中心的开关
POINT_MALL_SWITCH = True

# 医生详情页 专栏和免费招募 默认图片
DOCTOR_ARTICLE_DEFAULT_IMAGE = "http://hera.s.igengmei.com/2017/12/07/f5c394ab94"  # 专栏
DOCTOR_RECRUIT_DEFAULT_IMAGE = "http://hera.s.igengmei.com/2017/12/07/e022bf1add"  # 免费招募

# 搜索主页，医院热词推荐，若名称出现以下词，则去除
TRIM_WORDS = [
    u'门诊部',
    u'门诊',
    u'整复外科',
    u'外科',
    u'皮肤科',
    u'皮肤',
    u'医疗',
    u'诊所',
    u'医院',
    u'整形',
    u'美容',
    u'中心',
    u'有限公司',
    u'医学',
    u'口腔',
    u'集团',
    u'中心',
    u'机构',
    u'定妆',
    u'抗衰老',
    u'连锁',
    u'综合',
    u'牙科',
    u'研究所',
]

# 新人礼包的id信息
NEWBIE_COUPON_LANDING_PAGE = {
    'gift_id': 283,
    'business_channel_id': 78
}

# 支持common_webview域名
HOST_WHITE_LIST = ['igengmei.com', 'dev.env', 'test.env']

# 美购详情页ios灰度，
SERVICE_DETAIL_GRAY_IOS = []  # 去掉所有灰度
# SERVICE_DETAIL_GRAY_IOS = ["0", "1", "2", "3", "5", "6", "8", "9", "A", "B", "C", "D", "E", "F"]  # 不要 4 和 7
SPECIAL_ICON = "http://hera.s.igengmei.com/2018/01/05/e56e3c7956"  # 促销icon -美购详情页
# 回答浏览量开关
ANSWER_VIEW_SWITCH = False
SERVICE_DETAIL_IN_TEST = False   # 全量测试开关

# 消息类型
NOTIFY_TYPE = {
    NotificationType.REPLY_ME: u"回复",
    NotificationType.VOTE_ME: u"点赞",
    NotificationType.ANSWER_ME: u"回答",
}

# 消息类型 默认图
NOTIFICATION_DEFAULT_IMG = {
    NotificationType.ANSWER_ME: 'http://hera.s.igengmei.com/2018/01/24/f1dd7a0590',  # 消息-回答 默认图
    NotificationType.REPLY_ME: 'http://hera.s.igengmei.com/2017/07/28/c32ff57e7a',  # 消息-回复 默认图
}

# 医院详情页,美购和医生限制的展示个数
HOSPITAL_LIMIT_COUNT = 3

# 美购详情页灰度，内部人员新增名单
INNER_SERVICE_DETAIL_LIST = []
# INNER_SERVICE_DETAIL_LIST = [
#     'EA4930FC-F35A-44D8-BCE0-196352192463',
#     'E13E18F9-B71B-4BD7-B81F-C6C222EFCFB8',
#     '5F6B1802-C0F6-4F71-B2B2-74BF2788FE16',
#     'FB6FC357-25BC-465A-ABD5-2E65DA2CD878',
#     'B791190A-D2EA-4412-AA06-54D1C746D985',
#     '92607081-16A6-495F-8F15-69492CA71A54',
#     'F8A025C7-65B9-46F0-8532-0D5FFFB74D3C',
#     'B5CB364F-A9E7-4C69-BEC0-77D9619EA8C6',
#     '9F3E6D6D-0340-4855-8641-926F227EF9F3',
#     '68025109-3CC9-410E-9F7F-9EA12CBD8FCE',
#     '01158EEC-4C4A-4859-8D92-D3D719A490AA',
#     'A7131C4E-A310-42DD-8E29-6B225B651EC8',
#     'F3388187-75F7-4831-AA0C-1886FD332731',
#     'F08CB5F8-F09F-4AE1-8E87-09D1A087E03A',
#     '906660B7-4D93-4E78-8BA1-A0AC4BF2B3FA',
#     '6A99CBB1-6738-4ED1-A042-199CA80AAB22',
#     '7D2CD32E-5327-40C2-AF87-4ADC00143491',
#     'B268AC13-8FEA-4E1A-97FD-AEF7D13CEBC8',
#     'D15183E5-F2B7-466E-9F9E-3DA94974737A',  # added in 180326
#     '8DB6A723-A756-46D0-B857-96E12DDA8536',
#     '6926C81C-3988-4842-9D9E-214FFE9C8AD9',
#     '48ABDEBC-D1AE-41D3-B746-3EFC3E788ED7',
#     '75014D02-61E6-4E00-B266-9BEE2EB58E84',
#     'C06E3BB4-6E22-490D-B393-153C4BE5E609',
#     '2923C9E8-C87F-4A88-B96C-570FD71DFA72',
#     '00CA20EB-2719-4518-85CC-60E765AC526F',
# ]


# new wiki一级目录排序
# key值对应于gm_types/wiki/enum.py里面ITEM_H1, DRUG_H1, MACHINE_H1, MATERIAL_H1
# 排序规则：http://wiki.wanmeizhensuo.com/pages/viewpage.action?pageId=4445019&focusedCommentId=4446889#comment-4446889
NEW_WIKI_DIRECTORY_ORDER = {
    1050: 1,
    1060: 2,
    1080: 3,
    1100: 4,
    1010: 5,
    1020: 6,
    1090: 7,
    1030: 8,
    1040: 9,
    1070: 10,
    1160: 11,
    1120: 12,
    1110: 13,
    1130: 14,
    1140: 15,
    1170: 16,
    1150: 17,
    1180: 18,

    2030: 1,
    2010: 2,
    2020: 3,
    2060: 4,
    2040: 5,
    2080: 6,
    2090: 7,
    2070: 8,
    2100: 9,
    2110: 10,

    3020: 1,
    3030: 2,
    3010: 3,
    3040: 4,
    3060: 5,
    3070: 6,
    3050: 7,
    3090: 8,
    3080: 9,
    3100: 10,
    3120: 11,
    3110: 12,

    4020: 1,
    4010: 2,
    4030: 3,
    4060: 4,
    4050: 5,
    4040: 6,
}

# 新百科热门数据
HOT_ITEM = [
    {'name': u'抗初老', 'id': '53', 'type': 'collect', 'img_url': 'http://hera.s.igengmei.com/itemwiki/2018/02/08/9dee27926c'},
    {'name': u'硅胶隆鼻', 'id': '269', 'type': 'item', 'img_url': 'http://hera.s.igengmei.com/itemwiki/2018/02/08/077499c711'},
    {'name': u'射频微针', 'id': '132', 'type': 'item', 'img_url': 'http://hera.s.igengmei.com/itemwiki/2018/02/08/13a91195da'},
    {'name': u'玻尿酸塑形', 'id': '20', 'type': 'collect', 'img_url': 'http://hera.s.igengmei.com/itemwiki/2018/02/08/37d7923b82'},
    {'name': u'开内眼角', 'id': '287', 'type': 'item', 'img_url': 'http://hera.s.igengmei.com/itemwiki/2018/02/08/a1cd9cca77'},
    {'name': u'超声刀', 'id': '121', 'type': 'item', 'img_url': 'http://hera.s.igengmei.com/itemwiki/2018/02/08/71a1bbdb7f'},
    {'name': u'面部填充', 'id': '22', 'type': 'collect', 'img_url': 'http://hera.s.igengmei.com/itemwiki/2018/02/08/1b9c3a2550'},
    {'name': u'下巴修复', 'id': '74', 'type': 'collect', 'img_url': 'http://hera.s.igengmei.com/itemwiki/2018/02/08/e61fe24fe0'},
    {'name': u'热立塑', 'id': '165', 'type': 'item', 'img_url': 'http://hera.s.igengmei.com/itemwiki/2018/02/08/77ccebb77f'},
    {'name': u'彩光嫩肤', 'id': '136', 'type': 'item', 'img_url': 'http://hera.s.igengmei.com/itemwiki/2018/02/08/5e33b386d3'},
    {'name': u'射频紧肤', 'id': '119', 'type': 'item', 'img_url': 'http://hera.s.igengmei.com/itemwiki/2018/02/08/06d3b9a689'},
    {'name': u'祛眼袋', 'id': '103', 'type': 'collect', 'img_url': 'http://hera.s.igengmei.com/itemwiki/2018/02/08/06e11b92f7'},
    {'name': u'肉毒素除皱', 'id': '17', 'type': 'collect', 'img_url': 'http://hera.s.igengmei.com/itemwiki/2018/02/08/e30f4437a6'},
    {'name': u'假体隆胸', 'id': '212', 'type': 'item', 'img_url': 'http://hera.s.igengmei.com/itemwiki/2018/02/08/e9010269cf'},
    {'name': u'半永久纹眉', 'id': '7', 'type': 'item', 'img_url': 'http://hera.s.igengmei.com/itemwiki/2018/02/08/e7e7b8439c'},
]

HOT_DRUG = [
    {'name': u'瑞蓝', 'id': '25', 'type': 'brand', 'img_url': 'http://hera.s.igengmei.com/2018/02/09/b22f865474'},
    {'name': u'保妥适', 'id': '37', 'type': 'brand', 'img_url': 'http://hera.s.igengmei.com/2018/02/09/f8d9fc8357'},
    {'name': u'肉毒素', 'id': '34', 'type': 'brand', 'img_url': 'http://hera.s.igengmei.com/2018/02/09/b307e41395'},
    {'name': u'乔雅登', 'id': '23', 'type': 'brand', 'img_url': 'http://hera.s.igengmei.com/2018/02/09/aba2a9c8e3'},
    {'name': u'润百颜', 'id': '1', 'type': 'brand', 'img_url': 'http://hera.s.igengmei.com/2018/02/09/c50653f730'},
    {'name': u'伊婉', 'id': '41', 'type': 'brand', 'img_url': 'http://hera.s.igengmei.com/2018/02/09/e6970b1858'},
    {'name': u'润百颜水光针', 'id': '1', 'type': 'product', 'img_url': 'http://hera.s.igengmei.com/2018/02/09/5265c45702'},
    {'name': u'海薇', 'id': '31', 'type': 'brand', 'img_url': 'http://hera.s.igengmei.com/2018/02/09/58c57fb140'},
    {'name': u'欣菲聆', 'id': '2', 'type': 'brand', 'img_url': 'http://hera.s.igengmei.com/2018/02/09/46719d3981'},
    {'name': u'芯丝翠', 'id': '23', 'type': 'product', 'img_url': 'http://hera.s.igengmei.com/2018/02/09/54fd5715c5'},
]

HOT_MACHINE = [
    {'name': u'黄金微雕', 'id': '96', 'type': 'product', 'img_url': 'http://hera.s.igengmei.com/2018/02/09/93d2dbc181'},
    {'name': u'美版超声刀', 'id': '43', 'type': 'product', 'img_url': 'http://hera.s.igengmei.com/2018/02/09/48ab44acf8'},
    {'name': u'热立塑', 'id': '81', 'type': 'product', 'img_url': 'http://hera.s.igengmei.com/2018/02/09/8dedf13cb7'},
    {'name': u'热拉提', 'id': '45', 'type': 'product', 'img_url': 'http://hera.s.igengmei.com/2018/02/09/81d0e5e188'},
    {'name': u'超皮秒', 'id': '37', 'type': 'product', 'img_url': 'http://hera.s.igengmei.com/2018/02/09/43b8705394'},
    {'name': u'王者之冠', 'id': '54', 'type': 'product', 'img_url': 'http://hera.s.igengmei.com/2018/02/09/f35ca602d1'},
    {'name': u'飞顿Ⅱ号', 'id': '55', 'type': 'product', 'img_url': 'http://hera.s.igengmei.com/2018/02/09/0d5369f8ed'},
    {'name': u'月光脱毛', 'id': '88', 'type': 'product', 'img_url': 'http://hera.s.igengmei.com/2018/02/09/9e3069b746'},
    {'name': u'皇后光子', 'id': '70', 'type': 'product', 'img_url': 'http://hera.s.igengmei.com/2018/02/09/684199eadc'},
]

HOT_MATERIAL = [
    {'name': u'韩士生科', 'id': '117', 'type': 'product', 'img_url': 'http://hera.s.igengmei.com/2018/02/09/37346e49e8'},
    {'name': u'威宁鼻假体', 'id': '119', 'type': 'product', 'img_url': 'http://hera.s.igengmei.com/2018/02/09/0c68f69840'},
    {'name': u'康宁面假体', 'id': '127', 'type': 'product', 'img_url': 'http://hera.s.igengmei.com/2018/02/09/f1e8b3b9a5'},
    {'name': u'美国射极峰', 'id': '114', 'type': 'product', 'img_url': 'http://hera.s.igengmei.com/2018/02/09/3030417eba'},
    {'name': u'美国曼托', 'id': '104', 'type': 'product', 'img_url': 'http://hera.s.igengmei.com/2018/02/09/b9d2a4cbc3'},
    {'name': u'美国麦格', 'id': '105', 'type': 'product', 'img_url': 'http://hera.s.igengmei.com/2018/02/09/e86cc5861e'},
    {'name': u'美国娜绮丽', 'id': '106', 'type': 'product', 'img_url': 'http://hera.s.igengmei.com/2018/02/09/2f031e82b0'},
    {'name': u'恒生PPDO线', 'id': '131', 'type': 'product', 'img_url': 'http://hera.s.igengmei.com/2018/02/09/39629f6ebc'},
    {'name': u'隐适美', 'id': '140', 'type': 'product', 'img_url': 'http://hera.s.igengmei.com/2018/02/09/add165c3b7'},
    {'name': u'ITI种植体', 'id': '134', 'type': 'product', 'img_url': 'http://hera.s.igengmei.com/2018/02/09/d10acac18b'},
]

# v 7.6.60 微信小程序，精选回答列表页分享 默认标题
WECHAT_SELECTED_QUESTIONS_SHARE_TITLE = u"最专业、最“好看”的颜值问答社区！"
WECHAT_QUESTIONS_SHARE_IMAGE = "http://hera.s.igengmei.com/2018/03/19/097e5501f1"  # 问题、回答 详情页，精选回答列表页 分享默认图

SERVICE_DETAIL_POP_IMG = u'http://hera.s.igengmei.com/2018/03/19/e74e14301c'

# 内容聚合页(新圈子) 百科背景图

POLYMER_WIKI_DEFAULT_IMAGES = [
    "http://hera.s.igengmei.com/2018/04/03/92f6d26945",
    "http://hera.s.igengmei.com/2018/04/03/4335e3ab9d",
    "http://hera.s.igengmei.com/2018/04/03/6a4b5d61c5",
    "http://hera.s.igengmei.com/2018/04/03/c10ef08742",
    "http://hera.s.igengmei.com/2018/04/03/1a86c5f32e",
    "http://hera.s.igengmei.com/2018/04/03/c5f4d1a241",
    "http://hera.s.igengmei.com/2018/04/03/83c3e2507e",
    "http://hera.s.igengmei.com/2018/04/03/f391dacab8",
    "http://hera.s.igengmei.com/2018/04/03/63f1745113",
]

# 项目百科详情页 锚点icon图
WIKI_DETAIL_ICONS = [
    "http://hera.s.igengmei.com/2018/04/13/76b14444a7",  # 项目速览
    "http://hera.s.igengmei.com/2018/04/13/bc72f628f7",  # 项目档案
    "http://hera.s.igengmei.com/2018/04/13/f696cf4873",  # 治疗说明
    "http://hera.s.igengmei.com/2018/04/13/b767669bdf",  # 相关药品
    "http://hera.s.igengmei.com/2018/04/13/4ab08f37dd",  # 术前锦囊
    "http://hera.s.igengmei.com/2018/04/13/374c827c97",  # 术后锦囊
]

CPC_CLICK_PRODUCER__BOOTSTRAP_SERVERS = ""
CPC_CLICK_PRODUCER__TOPIC_NAME = "cpc-click-event"
CPC_PUBLISH_CPC_SERVICE_CLICK = True

INDEX_DIARY_SERVICE = [
    '867981020725936',
    '00CA20EB-2719-4518-85CC-60E765AC526F',
    '03E3692A-DD9A-443C-9481-6E882EF5DEA4',
    'EB8B8B98-F865-494D-8D87-C323714A6F53',
    'C098CA53-E755-4E7C-A327-89C599CAFA24',
    '359583073056568',
    '863863030384686',
]

SHOW_AD_ICON = True
DIARY_AD_ICON = "http://pic.igengmei.com/diary/2018/04/17/6e09648597-w"


GWL = [
    # 交易组
    "F3388187-75F7-4831-AA0C-1886FD332731",
    "6A99CBB1-6738-4ED1-A042-199CA80AAB22",
    "EB5AB253-6D49-4B01-943D-B9278C9F674A",
    "9C2A7797-16D3-4A9C-B19C-41A9AC186E61",

    # 社交组
    "C504140B-FACE-453D-A61C-1A056CF47A40",
    "98AAC4A9-8F69-4EBE-B8C2-39F47023DE1D",
    "AE024593-B832-4B23-BA16-DCB2B403D269",
    "4841C5E0-DCE8-4108-9432-9E46631AACA3",
    "826D4695-5D3F-40FC-8DF3-800F03CA32FB",
    "B42685C0-702F-4C54-8C9E-73AEC5F3AAEC",
    "30A24968-E6E0-429F-8BC4-91054C01F0F0",
    "19F592FE-A442-4372-A2AA-D873A8A870E9",
    "E362248A-0AA7-4ED0-856C-CBFDE0524F88",
    "BDC175AB-FB91-4590-ACE3-05128D159734",

    # 产品组
    "B268AC13-8FEA-4E1A-97FD-AEF7D13CEBC8",
    "03E3692A-DD9A-443C-9481-6E882EF5DEA4",
    "EB8B8B98-F865-494D-8D87-C323714A6F53",
    "C608EDA4-B305-4E1B-ABBD-6DDAD4EDAAF3",
    "00CA20EB-2719-4518-85CC-60E765AC526F",
    "androidid_4f7e1e999d5a0ad7",
    "CDD0756B-2DBA-43FB-93A4-8EC32A76A7CE",
    "CE5C0FF8-C830-4184-BEF6-A2F67BF9EFAA",
    "E1A4F2BF-8D0A-4465-8A3E-B8F562A38E2B",
    "865846039243795",
    "62B3D99D-F4A2-4104-BBB1-2B803F8A6943",
    "356156075348110",
    "3DB03D3C-A85E-4601-A8DE-CD1757D03048",

    # 测试组
    "704AA15F-FA9A-47C0-BFA3-AC8F21CDF5E8",
]

INDEX_SORT_GRAY_RULE = {
    'FDE6F4E3-E8DB-4E93-A5D1-26295AF3E894',
    'A8C6E0D0-804C-45FB-986E-14BBCAA4524F',
    '356156075348110',
    '788EE945-8227-46D0-A688-851B1677C147',
    '90609F49-5B8E-4895-B0BF-1DC461B8034F',
    'A9559223-A6BF-4CA8-93B3-107A71189E89',
    'androidid_3bb90a09dbf05da2',
    'EDEE004A-40AC-4ACD-9D3F-D54480EACEE9',
}

USER_DEFAULT_PORTRAIT = "http://pic.igengmei.com/user/icon@2x.png-w"  # 用户默认头像

# 吐槽小程序，问题详情页 banner 图对应的跳转类型
XCX_QUESTION_TOP = [XCX_LANDING_PAGE.A, XCX_LANDING_PAGE.B, ]
XCX_QUESTION_BOTTOM = [XCX_LANDING_PAGE.C, ]

# 小程序，下载落地页图片
# 小程序，下载落地页图片
XCX_DOWNLOAD_PAGE = {
    XCX_LANDING_PAGE.A: [
        "http://hera.s.igengmei.com/2018/06/01/7f064aca65",
        "http://hera.s.igengmei.com/2018/06/08/2f6536f749",
        "http://hera.s.igengmei.com/2018/06/01/2fb39c80d5",
        "http://hera.s.igengmei.com/2018/06/01/5c867ca3b9",
        "http://hera.s.igengmei.com/2018/06/01/8f296e5d9f",
        "http://hera.s.igengmei.com/2018/06/01/ab8849f7ca",
        "http://hera.s.igengmei.com/2018/06/01/9b2c304042",
        "http://hera.s.igengmei.com/2018/06/01/3c2c77ab7f",
    ],
    XCX_LANDING_PAGE.B: [
        "http://hera.s.igengmei.com/2018/06/01/a53f1c50d9",
        "http://hera.s.igengmei.com/2018/06/01/64a806c115",
        "http://hera.s.igengmei.com/2018/06/01/f0849ba4a7",
        "http://hera.s.igengmei.com/2018/06/01/60c73113ac",
        "http://hera.s.igengmei.com/2018/06/01/d12adeb292",
        "http://hera.s.igengmei.com/2018/06/01/2ab85d3fa5",
        "http://hera.s.igengmei.com/2018/06/01/b472773d36",
        "http://hera.s.igengmei.com/2018/06/01/0f7219a32e",
    ],
    XCX_LANDING_PAGE.C: [
        "http://hera.s.igengmei.com/2018/06/01/810134c3c4",
        "http://hera.s.igengmei.com/2018/06/01/f2b9338b93",
        "http://hera.s.igengmei.com/2018/06/01/9c6b09efde",
        "http://hera.s.igengmei.com/2018/06/01/4b8bc06acc",
        "http://hera.s.igengmei.com/2018/06/01/9146fe7c79",
        "http://hera.s.igengmei.com/2018/06/01/771bd17c26",
        "http://hera.s.igengmei.com/2018/06/01/cd417d8ee0",
        "http://hera.s.igengmei.com/2018/06/01/eb43e70f51",
    ],
}

INVENTED_ANSWER_NUM = 6  # 吐槽小程序，需要累加的虚拟回答数
COMPLAINTS_XCX_QUESTION_SHARE_TITLE = u"这里的情感八卦和校园猛料，真的很多"  # 吐槽小程序，分享默认文案
COMPLAINTS_XCX_QUESTION_SHARE_IMAGE = u"http://hera.s.igengmei.com/2018/05/30/5c9f318372"  # 吐槽小程序，分享默认图片

GMTRACER_PARSER = 'libs.utils.setup_tracer'
# 链路追踪采样率(float, 0 ~ 100.0)
TRACE_SAMPLE_RATE = 5.0

DEFAULT_SERVICE_DEGRADATION = False

#八卦聚合页具体id，用于针对八卦聚合页做文案适配
POLYMER_ID_IS_BAGUA = 6717

# 美购详情页的tab配置, 支持顺序, support_h5默认为True, 7710 UI2.0新增
SERVICE_DETAIL_TABS = [
    {'name': '美购', 'tab_type': 'service', 'support_h5': True, 'hybrid_url': '/hybrid/promotion/detail/{service_id}/?is_gray=1' },
    {'name': '评价', 'tab_type': 'comment', 'support_h5': True, 'hybrid_url': '/hybrid/promotion/{service_id}/evaluate_list?is_gray=1'},
    {'name': '日记', 'tab_type': 'diary', 'support_h5': False, 'hybrid_url': ''},
    {'name': '机构', 'tab_type': 'organization', 'support_h5': True, 'hybrid_url': '/hybrid/organization/{hospital_id}/?is_gray=1'},
    {'name': '详情', 'tab_type': 'detail', 'support_h5': True, 'hybrid_url': '/hybrid/promotion/detail/{service_id}/?tabs_type=detail&is_gray=1'},
    {'name': '推荐', 'tab_type': 'recommend', 'support_h5': True, 'hybrid_url': '/hybrid/promotion/detail/{service_id}/?tabs_type=service&is_gray=1'},
    {'name': '百科', 'tab_type': 'wiki', 'support_h5': True, 'hybrid_url': '/hybrid/promotion/detail/{service_id}/?tabs_type=wiki&is_gray=1'},
]

TONGDUN_PRODUCT_URL = "https://api.tongdun.cn/riskService/v1.1"
TONGDUN_CODE = "igengmei"
TONGDUN_IOS = "cc4076a41105435f84bd3ae2113ccd7a"
IOS_REGISTER = "Register_ios_20180629"
IOS_LOGIN = "Login_ios_20180629"
IOS_ACTIVE = "Activate_ios_20180718"
IOS_CLICK = "click_ios_20180718"
IOS_DETAIL = "click_ios_20180727"
IOS_MARKET = "Marketing_ios_20180629"
TONGDUN_ANDROID = "840df0168e03400c995bde4cabcdd152"
AND_REGISTER = "Register_android_20180629"
AND_LOGIN = "Login_android_20180629"
AND_ACTIVE = "Activate_android_20180718"
AND_CLICK = "click_android_20180718"
AND_DETAIL = "click_android_20180727"
AND_MARKET = "Marketing_android_20180629"
TONGDUN_XCX = "3a64562203194b18bd6c81d2216a259e"
XCX_MARKET = "Marketing_web_20180725"
GROUPBUY_WECHAT_SHARE_TITLE = "我{groupbuy_price}元拼了{default_price}元的{short_description}"
GROUPBUY_NOTE_URL = '/hybrid/csc/groupbuy_note'
ORDER_JUMP_DELAY_SECOND = 3

# 7715
# 默认聚合页背景图
POLYMER_BG_IMAGE_URL = 'http://hera.s.igengmei.com/slide/2018/09/05/3fd51762b3'
