# coding: utf-8

import os
import raven
from celery.schedules import crontab
import helios
import helios.rpc

BASE_DIR = os.path.dirname(os.path.dirname(__file__))

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = 'zng=%a*!bokrd#=%%rawhyp0)1qr15i#x7m@hetqd%z_+kv599'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = False

TEMPLATE_DEBUG = DEBUG

RAVEN_CONFIG = {}

# 顶部导航Tabs
TAB_INDEX = '/'
TAB_LIVE = '/live_list/'
TAB_TAGS = '/diary_list/'
TAB_PROMOTION = '/promotion_list/'
TAB_WIKI = '/wiki_list/'
TAB_EXPERT = '/expert_list/'
TAB_POST = '/post_list/'
TAB_HOSPITAL = '/hospital_list/'
TAB_TOPIC = '/topic_list/'
TAB_SEOCATEGORY = '/seocategory/list/'
TABS = [
    {'name': u'首页', 'url': TAB_INDEX},
    {'name': u'直播', 'url': TAB_LIVE},
    {'name': u'日记', 'url': TAB_TAGS},
    {'name': u'美购', 'url': TAB_PROMOTION},
    {'name': u'百科', 'url': TAB_WIKI},
    {'name': u'专家', 'url': TAB_EXPERT},
    {'name': u'医院', 'url': TAB_HOSPITAL},
    # {'name': u'问答', 'url': TAB_TOPIC},
    {'name': u'健康资讯', 'url': TAB_POST},
    # {'name': u'项目专题', 'url': TAB_SEOCATEGORY},  # 6.0没有该入口
]
SEARCH_TABS = [
    {'name': u'日记', 'url': TAB_TAGS},
    {'name': u'美购', 'url': TAB_PROMOTION},
    {'name': u'专家', 'url': TAB_EXPERT},
    {'name': u'医院', 'url': TAB_HOSPITAL},
]

# 医生机构tags显示的个数
DOCTOR_SHOW_TAGS_NUM = 6

# 首页默认显示的Tag
FRONT_DEFAULT_TAGS = [{'id': 1, 'color': '#ffd34e', 'position': 1, 'icon': 'http://hera.s.gengmei.cc/2014/12/24/b3076876ff'},
                      {'id': 2, 'color': '#ffae5e', 'position': 2, 'icon': 'http://hera.s.gengmei.cc/2014/12/24/2624935b91'},
                      # {'id': 13, 'color': '#ff877b', 'position': 3, 'icon': 'http://hera.s.gengmei.cc/2014/12/24/aef2541110'},
                      {'id': 3, 'color': '#ff6c8f', 'position': 4, 'icon': 'http://hera.s.gengmei.cc/2014/12/24/e7f379e88f'},
                      {'id': 7, 'color': '#9290f6', 'position': 5, 'icon': 'http://hera.s.gengmei.cc/2014/12/24/0ef5dafde4'},
                      {'id': 4, 'color': '#5e9bff', 'position': 6, 'icon': 'http://hera.s.gengmei.cc/2014/12/24/1eea8df935'},
                      {'id': 5, 'color': '#5dcdfc', 'position': 7, 'icon': 'http://hera.s.gengmei.cc/2014/12/24/85df448756'}]

# 医生默认头像
DEFAULT_EXPERT_PORTRAIT = 'http://pic.gmei.com/2015/03/13/fbde86be25-web'

# TDK
TDK = {
    'title': u'更美APP官网—微整形_整形美购_整形美容_微整形社区与微整形特卖平台',
    'keywords': u'更美，更美APP，更美APP官网，更美网，整形，整容，微整形',
    'description': u'更美APP原名完美诊所,拥有超过10000位三甲及知名民营医院的整形外科医生。为用户提供免费的整形咨询,还有知名整形医生的护肤、瘦脸、齿科、双眼皮等整形特价团购!'
}

# 百度阿拉丁KEY
ALADING_KEY = 't7bu89c9ys4ix5u7o6t7v8kuxbtos1qy'

SUOZHANG_UID = 22

DOCTOR_REGISTER_URL = 'http://doctor.gmei.com/doctor/register'
HOSPITAL_REGISTER_URL = 'http://doctor.gmei.com/hospital/register'

# gmei.com 域名对应的公司名称和备案号
COMPANY_NAME = '北京完美创意科技有限公司'
ICP_DOC = '2016-京ICP备13053291号-3 ©2016-京ICP证150877号'
RPC_INVOKER = helios.rpc.create_default_invoker(debug=DEBUG)

COUNTRY_CHINA_ID = 'china'
HOSPITAL_LIMIT_COUNT = 2
TAB_DEFAULT_ORDERING = 100

# SENTINEL相关配置
SENTINEL = {
    # sentinel开关(非线上环境建议关闭)
    'enable': False,

    # sentinel服务器地址列表
    'sentinels': [
        ('192.168.168.142', 26379), ('192.168.168.142', 26380), ('192.168.168.142', 26381),
    ],

    # redis-master的地址，与master-name的映射
    'masters': {
        ('192.168.168.142', '6379'): "ac1e0876_18eb",
    },
}

BROKER_URL = 'redis://192.168.168.142:6379/4'
BROKER_TRANSPORT_OPTIONS = {'visibility_timeout': 259200}  # 72 hours
CELERY_TIMEZONE = 'Asia/Shanghai'
CELERYBEAT_SCHEDULE = {
    'doctors2redis': {
        'task': 'app.tasks.doctors2redis',
        'schedule': crontab(minute=0, hour=3),
        'args': ()
    },
    'hospital2redis': {
        'task': 'app.tasks.hospital2redis',
        'schedule': crontab(minute=0, hour=3),
        'args': ()
    },
}

GMTRACER_PARSER = 'app.utils.setup_tracer'
# 采样率
TRACE_SAMPLE_RATE = 10.0
