# coding: utf-8

import os

from flag_ship.settings_base import *

ALLOWED_HOSTS = ['*']

# Application definition
INSTALLED_APPS = (
    'django.contrib.contenttypes',
    'django.contrib.staticfiles',
    'django_jinja',
    'helios',
    'viewbase',
    'app',
    'raven.contrib.django.raven_compat',
)

MIDDLEWARE_CLASSES = (
    'gm_tracer.middleware.TracerMiddleware',
    'gm_tracer.middleware.TracerExtraMiddleware',
    'app.middlewares.logger.LoggingMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'gm_logging.django.middleware.LoggingMiddleware',
    'app.middlewares.rpc.HeliosMiddleware',
    'gm_shield.django.middleware.GMShield',
)

SESSION_ENGINE = 'django.contrib.sessions.backends.cache'
SESSION_COOKIE_AGE = 60*60*24
ROOT_URLCONF = 'flag_ship.urls'
WSGI_APPLICATION = 'flag_ship.wsgi.application'

# Internationalization
# https://docs.djangoproject.com/en/1.7/topics/i18n/
LANGUAGE_CODE = 'en-us'
TIME_ZONE = 'Asia/Shanghai'
USE_I18N = True
USE_L10N = True
USE_TZ = True

# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/1.7/howto/static-files/
STATIC_URL = '/static/'
STATIC_ROOT = '/srv/apps/flag-ship/local/build/static'
STATICFILES_DIRS = (
    ('', os.path.join(BASE_DIR, '..', 'frontend', 'static')),
    ('', os.path.join(BASE_DIR, '..',  'fe', 'dist', 'static')),

)
STATICFILES_FINDERS = (
    'django.contrib.staticfiles.finders.FileSystemFinder',
    'django.contrib.staticfiles.finders.AppDirectoriesFinder',
)
TEMPLATE_LOADERS = (
    'django_jinja.loaders.FileSystemLoader',
    'django_jinja.loaders.AppLoader',
)
# TEMPLATE_DIRS = (
#      os.path.join(BASE_DIR, '..', 'frontend', 'templates'),
#      os.path.join(BASE_DIR, '..',  'fe', 'dist'),
# )
TEMPLATE_DIRS = (
   os.path.join(BASE_DIR, '..',  'local', 'build', 'templates'),
   os.path.join(BASE_DIR, '..',  'fe', 'dist'),
)
TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.jinja2.Jinja2',
        'DIRS': TEMPLATE_DIRS,
        'APP_DIRS': True,
        'OPTIONS': {
            'environment': 'app.utils.environment',
        },
    }
]
DEFAULT_JINJA2_TEMPLATE_EXTENSION = ''


# Captcha 验证码图片样式(1:数字运算;2.四位字符或者数字)
CAPTCHA_STYLE = 2
