import uuid
from datetime import timedelta, date

from celery.schedules import crontab
from gm_types.gaia import USER_RIGHTS_LEVEL

DATABASES = {
    'default': {  # mysql
        'ENGINE': 'django.db.backends.mysql',
        'NAME': 'mimas_test',
        'USER': 'work',
        'PASSWORD': 'Gengmei1',
        'HOST': 'rm-2ze0v6uua2hl9he8e.mysql.rds.aliyuncs.com',
        'PORT': '3306',
        'OPTIONS': {
            "init_command": "SET foreign_key_checks = 0;",
            "charset": "utf8mb4",
        },
    },
}

CELERY_TIMEZONE = 'Asia/Shanghai'
BROKER_URL = 'redis://192.168.168.142/0'
CELERY_TASK_SERIALIZER = "json"
SENTRY_CELERY_ENDPOINT = ''

BACKEND_API_HOST = 'https://backend.igengmei.com'

# 初始化数据
INIT_DATA = False

REDIS_CONF = {'host': '192.168.168.142', 'port': 6379, 'db': 0, }

# qa hack num
SUOZHANG_UID = 22

ANSWER_HACK_STRT = '-'

QINIU_CDN_HOST = u'http://pic.igengmei.com/'

MULTI_TOPIC_TAG_ID = 5089

GM_SERIALIZER = {
    'redis': {
        'host': '192.168.168.142', 'port': 6379, 'db': 1, 
    }
}

TEST_RUNNER = 'gm_test.runner.GmTestRunner'

REDIS = {
    'default': {'host': '192.168.168.142', 'port': 6379, 'db': 0, },
    'view': {'host': '192.168.168.142', 'port': 6379, 'db': 1, },
    'answer_sort_cache': {'host': '192.168.168.142', 'port': 6379, 'db': 4, },
    'high_quality_question_cache': {'host': '192.168.168.142', 'port': 6379, 'db': 5, },
    'vote_cache': {'host': '192.168.168.142', 'port': 6379, 'db': 6, },
    'user_cache': {'host': '192.168.168.142', 'port': 6379, 'db': 5, },
}

DATABASE_ROUTERS = ['utils.router.ThreadLocalRouter']

REDIS_MIGRATE = (
    {
        # gaia view_cache addr.
        'source': {'host': '192.168.168.142', 'port': 7777, 'db': 1, },
        'prefix': ('question_view', 'answer_view'),
        'target': REDIS['view']
    },
    {
        # gaia answer_sort_cache addr:
        'source': {'host': '192.168.168.142', 'port': 7777, 'db': 2, },
        'prefix': ('answer_sort_cache',),
        'target': REDIS['answer_sort_cache']
    },
    {
        # gaia vote_cache addr.
        'source': {'host': '192.168.168.142', 'port': 7777, 'db': 2, },
        'prefix': ('vote_cache',),
        'target': REDIS['vote_cache']
    },
)
# topic 迁移一期,暂时共用gaia redis
REDIS_TOPIC_1ST = {
    'default': {'host': '192.168.168.142', 'port': 6379, 'db': 14, },  # gaia settings.DEFAULT_REDIS
    'view': {'host': '192.168.168.142', 'port': 6379, 'db': 2, },  # gaia settings.REDIS['view']
    'talos_rpc_cache': {'host': '192.168.168.142', 'port': 6379, 'db': 14, },  # gaia settings.TALOS_RPC_CACHE
    'user_cache': {'host': '192.168.168.142', 'port': 6379, 'db': 5, },  # gaia settings.REDIS['user_cache']
    'page_cache': {'host': '192.168.168.142', 'port': 6379, 'db': 15, },  # gaia settings.REDIS['page_cache']
    'vote_cache': {'host': '192.168.168.142', 'port': 6379, 'db': 11, },  # gaia settings.REDIS['vote_cache']

}
REDIS_MIGRATE_TALOS = (
    {
        # gaia REDIS view addr.
        'source': {'host': '192.168.168.142', 'port': 7777, 'db': 1, },
        'prefix': ('diary_pv',),
        'target': REDIS['view']
    },
)

CELERYBEAT_SCHEDULE = {
    "build_high_quality_cache": {
        'task': 'qa.tasks.answer.build_high_quality_cache',
        'schedule': timedelta(seconds=3600),
        'args': (),
    },
    # 轮训七牛转码状态
    'check_water_mark_video_is_finish': {
        'task': 'live.tasks.check_water_mark_video_is_finish',
        'schedule': timedelta(seconds=300),
        'args': (),
    },

    # 生成直播回放帖子
    'save_replay_url': {
        'task': 'live.tasks.save_replay_url',
        'schedule': timedelta(minutes=30),
        'args': (),
    },
    # 直播状态检查
    'check_live_status': {
        'task': 'live.tasks.check_live_status',
        'schedule': timedelta(minutes=2),
        'args': (),
    },

    'add_fake_vote_num_list': {
        'task': 'live.tasks.add_fake_vote_num_list',
        'schedule': timedelta(minutes=1),
        'args': (),
    },
    # 已无调用 180411
    # v 7.6.65 更改 该功能不再使用！
    # 'hot_in_24hrs': {
    #     'task': 'talos.tasks.topic.hot_in_24hrs',
    #     'schedule': crontab(minute=0, hour='9,12,21'),
    #     'args': ()
    # },
    # 统计crash相关关键字帖子
    'crash_checkout': {
        'task': 'talos.tasks.crash_checkout.crash_check',
        'schedule': crontab(hour=3, minute=0),
        'args': (),
    },
    # 他人主页推荐关注的用户
    'create_high_quality_user_to_redis': {
        'task': 'talos.tasks.diary.create_high_quality_user_to_redis',
        'schedule': crontab(hour=3, minute=0),
        'args': (),
    },
    # 提醒用户更新日记
    "remind_user_to_update_diary": {
        'task': 'talos.tasks.diary.remind_user_to_update_diary',
        'schedule': crontab(day_of_month="*", hour="21", minute=0),
        'args': ()
    },
    # 计算帖子热度分数
    'calc_topic_ranking': {
        'task': 'talos.tasks.topic_ranking.calc_topic_ranking',
        'schedule': crontab(hour=4, minute=0),  # hour should be exactly the same as TopicRankingScore.SPLIT_HOUR
        'args': (),
    },
    'doctor_diary_tags': {
        'task': 'talos.tasks.diary.doctor_diary_tags',
        'schedule': crontab(minute=30, hour='6'),
        'args': ()
    },
    # 非日记帖，同步成问答
    'convert_topic_to_question': {
        'task': 'talos.tasks.topic.move_topic_to_answer',
        'schedule': crontab(hour=4, minute=0),
        'args': (),
    },
    'get_index_diary_detail': {
        'task': 'talos.tasks.diary.get_index_diary_detail',
        'schedule': crontab(hour=3, minute=0),
        'args': (),
    },
    'fake_vote_to_topics': {
        'task': 'talos.tasks.topic.fake_vote_to_topic',
        'schedule': crontab(minute=0, hour='0,8-23'),
        'args': (),
    },
    # 记录邀请人user_id列表池
    'build_inviter_pool': {
        'task': "qa.tasks.answer.build_inviter_pool",
        'schedule': crontab(hour=1, minute=0),
        'args': (),
    },
    # 每天下午5点，定时推送被邀请回答的用户，累计被邀请的次数。
    'time_push_to_invited_user': {
        'task': "qa.tasks.answer.time_push_to_invited_user",
        'schedule': crontab(hour=17, minute=0),
        'args': (),
    },
    'take_sofa_diary': {
        'task': 'talos.tasks.diary.take_sofa_diary',
        'schedule': timedelta(minutes=20),
        'args': (),
    },
    'default_diary_rating': {
        'task': 'talos.tasks.diary.default_diary_rating',
        'schedule': crontab(hour=3, minute=0),
        'args': (),
    },
    'preload_index_diaries': {
        'task': 'talos.tasks.period_tasks.preload_index_diaries',
        'schedule': timedelta(minutes=30),
        'args': (),
    },
    'mark_reply_spam': {
        'task': 'talos.tasks.period_tasks.mark_reply_spam',
        'schedule': crontab(minute=50, hour=23),
        'args': (),
    },
    # 抓取微信公众号数据
    'get_wechat_pgc': {
        'task': 'talos.tasks.topic.get_wechat_pgc',
        'schedule': crontab(hour=3, minute=0),
        'args': (),
    },
    'rerun_wechat_pgc': {
        'task': 'talos.tasks.topic.rerun_pgc',
        'schedule': crontab(hour='*/3', minute=0),
        'args': (),
    },
    'preload_operation_tags': {
        'task': 'talos.tasks.period_tasks.preload_tags',
        'schedule': timedelta(minutes=60),
        'args': (),
    },
    'hospital_topics_nums': {
        'task': 'talos.tasks.diary.hospital_topics_num',
        'schedule': crontab(hour=2, minute=10),
        'args': (),
    },

    # 早上五点进行pv同步
    'sync_diary_pv': {
        'task': 'talos.tasks.diary.update_diary_pv',
        'schedule': crontab(minute=0, hour=5),
        'args': (),
    },
    # 每两个小时计算一次推荐问题数据
    "get_relation_college_tag_questions": {
        "task": "qa.tasks.answer.get_relation_college_tag_questions",
        "schedule": timedelta(hours=2),
        "args": (),
    },

}

ES_INDEX_PREFIX = 'gm_test'
ES_HOSTS = [
    {'host': '192.168.168.142', 'port': 9200},
]
LOGICAL_DATABASE_ID = 'mimas_test'

# listing decorator.
COUNT_LIMIT = 100
VERSION = uuid.uuid1()

QUESTION_SCORE_WEIGHT = {
    'time_score_weight': 1,  #
    'answers_num_score_weight': 1,
    'answer_views_score_weight': 1,
    'answer_likes_score_weight': 1,
    'question_view_score_weight': 1,
    'question_answer_likes_score_weight': 1,
}

DIARY_HEAT_RANK = {
    'lose_rate': 0.006,  # 热度分时间衰减比率  0.006/hour/热度分
    'max_score': 50,  # 最大热度分
    'reply_num_per_device': 3,  # 每设备评论每天限制三次
    # 加分相关
    'score_create_topic': 4,
    'score_modify_diary': 2,
    'score_self_reply': 1,
    'score_other_reply': 1,
    'score_other_vote': 0.5,
    # 限制相关
    'restrict_create_topic': 2,
    'restrict_modify_diary': 1,
    'restrict_self_reply': 10,
    'restrict_other_reply': 15,
    'restrict_other_vote': 20,
}

SEND_MSG_TIME = 10
MSG_POLL_TIME = 4
LIVE_TIME_OUT = 15 * 60
ENTER_MSG_TIME = 2 * 60
QINIU_TEMP_CDN_HOST = u'http://pic-tmp.igengmei.com/'
LIVE_MSG_REDIS_FLAG = False

# 网易易盾反垃圾
YD_SECRET_ID = '914c9cb763500c23acdf121faed02c31'
YD_SECRET_KEY = 'ffb43924f88946f7d5b7aac1832a18e5'
YD_BUSINESS_ID = '8034f7ed207ec691c3f30d318e06e0c7'

# 特殊推送限制
SPECTAL_SECONDS_LIMIT = 7200
SPECIAL_PUSH_LIMIT = 4
PUSH_SUB_LIMIT = 1  # 子项，每日只能发一次
PERSON_GET_COMMENT_PUSH_LIMIT = 5  # 评论的每日收到的推送次数


LEVEL_UPPER_GAIN_POINTS = 200   # 每升一等级，增加美分200
USER_EVENT_MULTI_TIMES = 6  # 累计操作次数，给予不同的美分、成长值奖励

POINT_DAILY_LIMIT = 400  # 美分每日上限
GROWTH_DAILY_LIMIT = 300    # 成长值每日上限

UNSHOW_TAGS = [u'美购日记', u'所长精选', u'热门讨论']

# 评论图片和字数限制
CASHBACK_TOPIC_IMAGE_LIMIT = 2
CASHBACK_TOPIC_CONTENT_WORDS_LIMIT = 20
ELITE_LIKE_NUM = 5
HOT_TOPIC_VOTE_THRESHOLD = 10
HOT_TOPIC_VOTE_THRESHOLD_IN_ZONE = 10
REPLIES_READ_MYSQL_FLAG = True

NOTIFICATION_REPLY_IMG = 'http://hera.s.igengmei.com/2017/07/28/c32ff57e7a'
NOTIFICATION_VOTE_IMG = 'http://hera.s.igengmei.com/2017/07/28/d7e0c06fb0'

# 检索时间
DAYS_BEFORE_TODAY = -1
# 短视频权限起始等级
CAN_CREATE_VIDEO_LEVEL = USER_RIGHTS_LEVEL.V3
SHOW_VIDEO_COVER = True

HOT_DISCUSSION_TAG_DIARY_SHRESHOLD = 1000
HOT_DISCUSSION_TAG_CONSULT_SHRESHOLD = 30
HOT_DISCUSSION_TAG_DISCUSS_SHRESHOLD = 100

VIDEO_PIC_URL = u'?vframe/jpg/offset/0/rotate/auto'
VIDEO_HOST = u'http://video-static.igengmei.com/'

FOUNDING_DAY = date(2013, 8, 8)
SOCIAL_REPLY_WEIGHT = 0.7
SOCIAL_LIKE_WEIGHT = 0.3
CONTENT_WEIGHT = 0.4
SOCIAL_WEIGHT = 0.3
TIME_WEIGHT = 0.045

DIARY_COVER_DEFAULT = 'http://hera.s.igengmei.com/2015/10/16/61b745cb36'

# for SLAVE_DB_NAME
SLAVE_DB_NAME = 'default'

# 邀请人筛选条件，优良回答 总数 > 3
INVITER_LIMIT_FORM_ANSWER = 3
INVITE_QUESTION_LIST_PAGE = "/hybrid/question/question_list"  # 去回答列表页

SUBJECT = u'用户版－用户反馈崩溃日报'
CRASH_KEYWORDS = ['crash', u'闪退', u'软件崩溃', u'软件问题', u'app问题']
SENDTO = ['linli@igengmei.com']
# model中检索的字段
MODEL_FIELDS = {'diary': ['title'], 'problem': ['ask', 'answer'], 'topicreply': ['content']}
# 日记本质量分
DIARY_CONTENT_LEVEL_SCORE = {
    'UNAUDITED': -1000,
    'ILLEGAL': -1000,
    'BAD': -1000,
    'GENERAL': -1000,
    'BETTER': -1000,  # 新增内容等级 3.5，和郑伟确认先按照 -1000给值
    'FINE': 65.0,
    'EXCELLENT': 100.0

}

BUILD_SITEMAP_COUNT = 1000
# rating limit
DIARY_RATING_LIMIT = 2

VIDEO_TAG_ID = 4706   # 如果有小视频 就给日记本添加视频日记的tag

# weixin js sdk
# 正式账号
WX_APP_ID = 'wx19c0bdd0c9e25acb'
WX_APP_SECRET = '41855cb5fd32338435b2c7dbaa400716'
WX_USER_ID = 20889703

MIP_LIMIT = 10
# 首页Feed随机比例
DIARY_RANDOM_SCALE = {
    "wuhan": 10,
    "beijing": 15,
    "guangzhou": 10,
    "chengdu": 10,
    "shanghai": 10,
    "chongqing": 10,
    "hangzhou": 10,
    "shenzhen": 10,
}
ANSWER_NUM_BASELINE = 4  # 回答数基本限制

# 计算回答子评论未读数的起始时间
COUNT_ANSWER_COMMENTED_REPLY_START_TIME = '2018-08-15 15:23:00'
